/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.control.NonAlphaNumWordSplitter;
import org.junit.Assert;
import org.junit.Test;

public class NonAlphaNumWordSplitterTest {
    private NonAlphaNumWordSplitter splitter = new NonAlphaNumWordSplitter();

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnMultipleWordInput() {
        this.splitter.split("two words");
    }

    @Test
    public void shouldNotSplitSingleWord() {
        String[] parts = this.splitter.split("SingleAlphaNumW0rd");
        Assert.assertEquals((long)1L, (long)parts.length);
    }

    @Test
    public void shouldNotSplitSingleWordOnApostroph() {
        String[] parts = this.splitter.split("That's");
        Assert.assertEquals((long)1L, (long)parts.length);
    }

    @Test
    public void shouldURLWithParams() {
        Object[] parts;
        String url = "http://en.wikipedia.org/wiki/Hanseatic_League?p1=v1&p2=v2,2011-03-06";
        Object[] expected = new String[]{"http:", "/", "/", "en.", "wikipedia.", "org/", "wiki/", "Hanseatic_", "League?", "p1=", "v1&", "p2=", "v2,", "2011-", "03-", "06"};
        for (String string : parts = this.splitter.split(url)) {
            System.out.print(string);
            System.out.print(" ");
        }
        System.out.println("");
        for (String string : expected) {
            System.out.print(string);
            System.out.print(" ");
        }
        Assert.assertArrayEquals((Object[])expected, (Object[])parts);
    }
}

