/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.service.NoticeBoardShipyardMenuProvider;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.LinkedHashSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@RunWith(value=MockitoJUnitRunner.class)
public class NoticeBoardShipyardMenuProviderTest {
    @Mock
    private Locale locale;
    @Mock
    private MessageSource messageSource;
    @Mock
    private ApplicationContext context;
    @Mock
    private DecoratedTextFactory textFactory;
    @InjectMocks
    private NoticeBoardShipyardMenuProvider menuProvider;

    @Test
    public void shouldProvideFourMenuItems() {
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)java.util.Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        LinkedHashSet entries = this.menuProvider.createMenuEntries((ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class), null);
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)6))).getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class));
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory, (VerificationMode)Mockito.times((int)6))).createSimpleDecoratedText(Matchers.anyString());
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.SHIPYARD_CONSTRUCTION});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.SHIPYARD_REPAIR});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.SHIPYARD_CONSTRUCTION_LIST});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.SHIPYARD_REPAIR_LIST});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.SHIPYARD_UPGRADE});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.SHIPYARD_RENAME});
        Assert.assertEquals((long)6L, (long)entries.size());
    }
}

