/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.util;

import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.OpenPatricianReflectionUtils;
import java.util.Locale;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.support.ResourceBundleMessageSource;

public class ModelTranslationsTest
extends OpenPatricianReflectionUtils {
    private ModelTranslations modelTranslations;

    @Before
    public void setup() {
        this.modelTranslations = new ModelTranslations();
        ch.sahits.game.openpatrician.util.l10n.Locale locale = new ch.sahits.game.openpatrician.util.l10n.Locale();
        locale.setLocale(Locale.ENGLISH);
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("i18n/text");
        this.setField("locale", locale, this.modelTranslations);
        this.setField("messages", messageSource, this.modelTranslations);
    }

    @Test
    public void shouldRetrieveShortDate() {
        DateTime dateTime = new DateTime(1291, 4, 28, 3, 43, 47);
        String shortDate = this.modelTranslations.toShortDate(dateTime);
        Assert.assertEquals((Object)"28. Apr", (Object)shortDate);
    }

    @Test
    public void shouldGetShortDateEndOfWeek() {
        DateTime date = new DateTime(2016, 5, 11, 5, 32, 19);
        String shortDate = this.modelTranslations.getEndOfWeek(date);
        Assert.assertEquals((Object)"15. May", (Object)shortDate);
    }

    @Test
    public void shouldRetrieveDisplayString() {
        DateTime dateTime = new DateTime(1291, 4, 28, 3, 43, 47);
        String shortDate = this.modelTranslations.toDisplayString(dateTime);
        Assert.assertEquals((Object)"28. Apr 1291", (Object)shortDate);
    }

    @Test
    public void shouldRetrieveDisplayString2() {
        String shortDate = this.modelTranslations.toDisplayString(28, 4, 1291);
        Assert.assertEquals((Object)"28. Apr 1291", (Object)shortDate);
    }

    @Test
    public void shouldGetShortDateStartOfWeek() {
        DateTime date = new DateTime(2016, 5, 11, 5, 32, 19);
        String shortDate = this.modelTranslations.getStartOfWeek(date);
        Assert.assertEquals((Object)"9. May", (Object)shortDate);
    }
}

