/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.control.IApplicableStyle;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.FlowPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

@ClassCategory(value={EClassCategory.JAVAFX})
public class DecoratedText
extends FlowPane
implements IApplicableStyle,
Styleable {
    private IntegerProperty wrappingWidth = new SimpleIntegerProperty((Object)this, "wrappingWidth", 0);
    private StyleableObjectProperty<Font> font;

    public DecoratedText() {
        super(Orientation.HORIZONTAL);
        this.getStylesheets().add((Object)this.getClass().getResource(this.getClass().getSimpleName() + ".css").toExternalForm());
        this.prefWidthProperty().bindBidirectional((Property)this.wrappingWidth);
    }

    public DecoratedText(String styleClass) {
        super(Orientation.HORIZONTAL);
        this.getStylesheets().add((Object)this.getClass().getResource(this.getClass().getSimpleName() + ".css").toExternalForm());
        this.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)styleClass);
        this.prefWidthProperty().bindBidirectional((Property)this.wrappingWidth);
    }

    public void append(String text) {
        if (text.endsWith("\n")) {
            Text decoText = new Text(text);
            decoText.getStyleClass().add((Object)"decoratedText");
            decoText.wrappingWidthProperty().bind((ObservableValue)this.wrappingWidth);
            this.getChildren().add((Object)decoText);
        } else {
            String[] parts;
            for (String part : parts = text.split("(?<! ) |(?<= {5})")) {
                Text decoText = new Text(part + " ");
                decoText.getStyleClass().add((Object)"decoratedText");
                this.getChildren().add((Object)decoText);
            }
        }
    }

    public void setText(String text) {
        Text decoText = new Text(text);
        this.getChildren().add((Object)decoText);
    }

    public void applyTextStyle(boolean add, String ... styleClasses) {
        for (Node node : this.getChildren()) {
            if (!(node instanceof Text)) continue;
            if (add) {
                node.getStyleClass().addAll((Object[])styleClasses);
                continue;
            }
            node.getStyleClass().removeAll((Object[])styleClasses);
        }
    }

    public void append(Node control) {
        this.getChildren().add((Object)control);
    }

    public int getWrappingWidth() {
        return this.wrappingWidth.get();
    }

    public IntegerProperty wrappingWidthProperty() {
        return this.wrappingWidth;
    }

    public void setWrappingWidth(int wrappingWidth) {
        this.wrappingWidth.set(wrappingWidth);
    }

    @Override
    public void applyStyle(String style) {
        for (Node node : this.getChildren()) {
            if (node instanceof IApplicableStyle) {
                ((IApplicableStyle)node).applyStyle(style);
                continue;
            }
            node.setStyle(style);
        }
    }

    public Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new SimpleStyleableObjectProperty(StyleableProperties.FONT, (Object)this, "font", (Object)Font.getDefault());
        }
        return this.font;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return DecoratedText.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<DecoratedText, Font> FONT = new CssMetaData<DecoratedText, Font>("-fx-font", StyleConverter.getFontConverter(), Font.getDefault()){

            public boolean isSettable(DecoratedText control) {
                return control.font == null || !control.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(DecoratedText control) {
                return control.fontProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

