/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.DisplayMessageOverlayLabel;
import ch.sahits.game.javafx.control.TextSizingUtility;
import java.io.InputStream;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;

public class DisplayMessageOverlayLabelSkin
extends SkinBase<DisplayMessageOverlayLabel> {
    private final DisplayMessageOverlayLabel control;
    private final TextSizingUtility sizing;
    private DoubleProperty textLength = new SimpleDoubleProperty(0.0);
    private final Image waxBtnMiddle;
    private final double middleSectionWidth;

    public DisplayMessageOverlayLabelSkin(DisplayMessageOverlayLabel control, TextSizingUtility sizing) {
        super((Control)control);
        this.control = control;
        this.sizing = sizing;
        this.textLength.set(sizing.calculate(control.getText(), control.getFont()).getWidth());
        control.fontProperty().addListener((observable, oldFont, newFont) -> this.textLength.set(sizing.calculate(control.getText(), (Font)newFont).getWidth()));
        control.textProperty().addListener((observable, oldText, newText) -> this.textLength.set(sizing.calculate((String)newText, control.getFont()).getWidth()));
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("waxButton-middle.png");
        this.waxBtnMiddle = new Image(is);
        is = ((Object)((Object)this)).getClass().getResourceAsStream("waxButton-left.png");
        Image leftEnd = new Image(is);
        is = ((Object)((Object)this)).getClass().getResourceAsStream("waxButton-right.png");
        Image rightEnd = new Image(is);
        this.middleSectionWidth = this.waxBtnMiddle.getWidth();
        BorderPane borderPane = new BorderPane();
        ImageView left = new ImageView(leftEnd);
        ImageView right = new ImageView(rightEnd);
        StackPane middleSection = new StackPane();
        HBox waxButon = new HBox();
        Label label = new Label(control.getText());
        label.getStyleClass().add((Object)"display-message-label");
        if (control.isLinkText()) {
            label.getStyleClass().add((Object)"display-message-link");
        }
        control.linkTextProperty().addListener((observable, oldFlag, newFlag) -> {
            if (newFlag.booleanValue() && oldFlag != newFlag) {
                label.getStyleClass().add((Object)"display-message-link");
            } else {
                label.getStyleClass().remove((Object)"display-message-link");
            }
        });
        label.textProperty().bind((ObservableValue)control.textProperty());
        int nbSegments = (int)Math.ceil(this.textLength.getValue() / this.middleSectionWidth);
        for (int i = 0; i < nbSegments; ++i) {
            waxButon.getChildren().add((Object)new ImageView(this.waxBtnMiddle));
        }
        middleSection.getChildren().addAll((Object[])new Node[]{waxButon, label});
        this.textLength.addListener((observable, oldWidth, newWidth) -> {
            int numberSegments = (int)Math.ceil(newWidth.doubleValue() / this.middleSectionWidth);
            waxButon.getChildren().clear();
            for (int i = 0; i < numberSegments; ++i) {
                waxButon.getChildren().add((Object)new ImageView(this.waxBtnMiddle));
            }
        });
        borderPane.setLeft((Node)left);
        borderPane.setRight((Node)right);
        borderPane.setCenter((Node)middleSection);
        this.getChildren().addAll((Object[])new Node[]{borderPane});
    }
}

