/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.OpenPatricianSpinner;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.javafx.model.OpenPatricianSpinnerOptionDataModel;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import java.io.InputStream;
import javafx.collections.ObservableList;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;

@ClassCategory(value={EClassCategory.JAVAFX})
public class OpenPatricianSpinnerSkin
extends SkinBase<OpenPatricianSpinner> {
    private final OpenPatricianSpinner spinner;
    private TextSizingUtility sizing = new TextSizingUtility();
    private final TextField textField;
    private ImageView imgViewPlank;
    private final double additionalWidth;

    public OpenPatricianSpinnerSkin(OpenPatricianSpinner spinner) {
        super((Control)spinner);
        this.spinner = spinner;
        this.textField = new TextField("");
        Font font = spinner.getFont();
        spinner.fontProperty().addListener((observalbe, oldValue, newValue) -> {
            this.calculateNewDimension((Font)newValue);
            if (!spinner.getOptions().isEmpty()) {
                this.updateDisplayCurrentSelectedValue();
            }
        });
        this.calculateNewDimension(font);
        if (!spinner.getOptions().isEmpty()) {
            this.updateDisplayCurrentSelectedValue();
        }
        spinner.optionsProperty().addListener((observable, oldValue, newValue) -> {
            String internalFirst = "";
            if (!spinner.getOptions().isEmpty()) {
                spinner.selectedIndexProperty().set(0);
                this.updateDisplayCurrentSelectedValue();
            }
            this.textField.setText(internalFirst);
            this.calculateNewDimension(font);
            if (!spinner.getOptions().isEmpty()) {
                this.updateDisplayCurrentSelectedValue();
            }
        });
        HBox hbox = new HBox();
        this.textField.getStyleClass().add((Object)"openPatricianSpinner");
        this.textField.setEditable(false);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("SlabUp.png");
        Image img = new Image(is);
        double imgWidth = img.getWidth();
        ImageView imgViewUp = new ImageView(img);
        is = ((Object)((Object)this)).getClass().getResourceAsStream("SlabDown.png");
        img = new Image(is);
        ImageView imgViewDown = new ImageView(img);
        this.additionalWidth = Math.max(img.getWidth(), imgWidth);
        Group textGroup = new Group(new Node[]{this.textField});
        VBox vbox = new VBox();
        vbox.getChildren().addAll((Object[])new Node[]{imgViewUp, imgViewDown});
        hbox.getChildren().addAll((Object[])new Node[]{textGroup, vbox});
        Group background = new Group(new Node[]{this.imgViewPlank, hbox});
        imgViewUp.setOnMouseReleased(event -> {
            if (this.isNumeticalOptions()) {
                this.selectNextInList(spinner);
            } else {
                this.selectPreviousInList(spinner);
            }
        });
        imgViewDown.setOnMouseReleased(event -> {
            if (this.isNumeticalOptions()) {
                this.selectPreviousInList(spinner);
            } else {
                this.selectNextInList(spinner);
            }
        });
        background.setManaged(false);
        this.getChildren().add((Object)background);
    }

    private void updateDisplayCurrentSelectedValue() {
        ObservableList<OpenPatricianSpinnerOptionDataModel> l = this.spinner.getOptions();
        int selectedIndex = Math.max(0, this.spinner.getSelectedIndex());
        OpenPatricianSpinnerOptionDataModel option = (OpenPatricianSpinnerOptionDataModel)l.get(selectedIndex);
        String value = option.getDisplay();
        this.textField.setText(value);
        if (option.isEllipsed()) {
            Tooltip tooltip = new Tooltip(option.getOption());
            this.textField.setTooltip(tooltip);
        } else {
            this.textField.setTooltip(null);
        }
    }

    private boolean isNumeticalOptions() {
        String str = ((OpenPatricianSpinnerOptionDataModel)this.spinner.getOptions().get(0)).getDisplay();
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    private void selectPreviousInList(OpenPatricianSpinner spinner) {
        ObservableList<OpenPatricianSpinnerOptionDataModel> options1 = spinner.getOptions();
        if (!options1.isEmpty() && spinner.getSelectedIndex() > 0) {
            spinner.decSelectedIndex();
            this.updateDisplayCurrentSelectedValue();
        }
    }

    private void selectNextInList(OpenPatricianSpinner spinner) {
        ObservableList<OpenPatricianSpinnerOptionDataModel> options1 = spinner.getOptions();
        if (!options1.isEmpty() && spinner.getSelectedIndex() < options1.size()) {
            spinner.incSelectedIndex();
            this.updateDisplayCurrentSelectedValue();
        }
    }

    private void calculateNewDimension(Font font) {
        ObservableList<OpenPatricianSpinnerOptionDataModel> options = this.spinner.getOptions();
        Dimension2D dim4heigth = this.sizing.calculate(1, font);
        double maxWidth = this.spinner.getMaxWidth();
        double destinationHeigth = dim4heigth.getHeight();
        if (this.imgViewPlank != null) {
            double imageHeigth = this.imgViewPlank.getImage().getHeight();
            destinationHeigth = Math.max(imageHeigth, destinationHeigth);
        }
        Dimension2D dim = new Dimension2D(maxWidth, destinationHeigth);
        this.textField.setMinWidth(dim.getWidth());
        this.textField.setMaxSize(dim.getWidth(), dim.getHeight());
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("InputPlank.jpg");
        Image img = new Image(is, dim.getWidth() + this.additionalWidth, dim.getHeight(), false, true);
        if (this.imgViewPlank == null) {
            this.imgViewPlank = new ImageView(img);
        } else {
            this.imgViewPlank.setImage(img);
        }
        for (OpenPatricianSpinnerOptionDataModel entry : options) {
            String word = entry.getOption();
            Dimension2D dim4width = this.sizing.calculate(word, font);
            if (!(dim4width.getWidth() > dim.getWidth())) continue;
            double percentage = dim.getWidth() / dim4width.getWidth();
            int nbChars = word.length();
            int endIndex = (int)(Math.floor((double)nbChars * percentage) - 3.0);
            String ellipsedWord = word.substring(0, endIndex) + "...";
            entry.setDisplay(ellipsedWord);
        }
    }
}

