/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.ImageFactory;
import ch.sahits.game.javafx.control.OpenPatricianButton;
import ch.sahits.game.javafx.control.OpenPatricianStoneButton;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;

@ClassCategory(value={EClassCategory.JAVAFX})
public class OpenPatricianStoneButtonSkin
extends SkinBase<OpenPatricianStoneButton> {
    private final ImageView imageView;
    private final OpenPatricianButton button;

    public OpenPatricianStoneButtonSkin(OpenPatricianStoneButton button) {
        super((Control)button);
        this.button = button;
        Dimension2D dim = this.calculateButtonDimensions(button);
        ImageFactory imageFactory = new ImageFactory();
        Image img = imageFactory.getSlabImage(dim);
        this.imageView = new ImageView(img);
        button.fontProperty().addListener((observable, oldvalue, newValue) -> this.calculateNewDimensions());
        Label label = new Label(button.getText());
        label.onMouseClickedProperty().bind(button.onActionProperty());
        this.imageView.onMouseReleasedProperty().bind(button.onActionProperty());
        button.textProperty().addListener((observable, oldValue, newValue) -> this.calculateNewDimensions());
        StackPane stack = new StackPane();
        stack.getChildren().addAll((Object[])new Node[]{this.imageView, label});
        Group group = new Group(new Node[]{stack});
        group.setManaged(false);
        this.getChildren().add((Object)group);
    }

    private void calculateNewDimensions() {
        Dimension2D dim = this.calculateButtonDimensions(this.button);
        ImageFactory imageFactory = new ImageFactory();
        Image img = imageFactory.getSlabImage(dim);
        this.imageView.setImage(img);
    }

    private Dimension2D calculateButtonDimensions(OpenPatricianButton button) {
        Dimension2D dim = new TextSizingUtility().calculate(button.getText(), button.getFont());
        return new Dimension2D(dim.getWidth() * 1.2, dim.getHeight() * 1.2);
    }
}

