/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.layout;

import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

public class StretchRightBottomLayout
extends StackPane {
    private final int topMargin;
    private final int leftMargin;
    private Double originalWidth = null;
    private Double originalHeight = null;

    public StretchRightBottomLayout(int topMargin, int leftMargin) {
        this.topMargin = topMargin;
        this.leftMargin = leftMargin;
    }

    protected void layoutChildren() {
        List managed = this.getManagedChildren();
        double width = this.getWidth();
        double height = this.getHeight();
        if (this.originalWidth == null) {
            this.originalWidth = width;
        }
        if (this.originalHeight == null) {
            this.originalHeight = height;
        }
        double scaleX = Math.min(this.computeScaleX(width), 1.0);
        double scaleY = Math.min(this.computeScaleY(height), 1.0);
        double top = this.getInsets().getTop() + (double)this.topMargin * scaleY;
        double right = this.getInsets().getRight();
        double left = this.getInsets().getLeft() + (double)this.leftMargin * scaleX;
        double bottom = this.getInsets().getBottom();
        double baselineOffset = height / 2.0;
        for (int i = 0; i < managed.size(); ++i) {
            Node child = (Node)managed.get(i);
            Pos childAlignment = StretchRightBottomLayout.getAlignment((Node)child);
            this.layoutInArea(child, left, top, width - left - right, height - top - bottom, baselineOffset, StretchRightBottomLayout.getMargin((Node)child), childAlignment != null ? childAlignment.getHpos() : this.getAlignment().getHpos(), childAlignment != null ? childAlignment.getVpos() : this.getAlignment().getVpos());
        }
    }

    private double computeScaleX(double width) {
        return width / this.originalWidth;
    }

    private double computeScaleY(double height) {
        return height / this.originalHeight;
    }
}

