/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.control.BaseItemNavigatorLabelWrapper;
import ch.sahits.game.javafx.control.IItemNavigatorLabelWrapper;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import java.util.ArrayList;
import java.util.List;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class ItemNavigatorLabelWrapperFactory {
    public List<IItemNavigatorLabelWrapper<IShip>> createListForVessels(List<IShip> ships) {
        ArrayList<IItemNavigatorLabelWrapper<IShip>> list = new ArrayList<IItemNavigatorLabelWrapper<IShip>>();
        for (IShip ship : ships) {
            list.add(new ShipNavigatorWrapper(ship));
        }
        return list;
    }

    public List<IItemNavigatorLabelWrapper<IPlayer>> createListForPlayer(List<IPlayer> persons) {
        ArrayList<IItemNavigatorLabelWrapper<IPlayer>> list = new ArrayList<IItemNavigatorLabelWrapper<IPlayer>>();
        for (IPlayer person : persons) {
            list.add(new PersonNavigatorWrapper(person));
        }
        return list;
    }

    public List<IItemNavigatorLabelWrapper<IPlayer>> createNonLabeledListForPlayer(List<IPlayer> persons) {
        ArrayList<IItemNavigatorLabelWrapper<IPlayer>> list = new ArrayList<IItemNavigatorLabelWrapper<IPlayer>>();
        for (IPlayer person : persons) {
            list.add(new NonDisplayablePersonNavigatorWrapper(person));
        }
        return list;
    }

    private static class NonDisplayablePersonNavigatorWrapper
    extends BaseItemNavigatorLabelWrapper<IPlayer> {
        public NonDisplayablePersonNavigatorWrapper(IPlayer item) {
            super(item);
        }

        @Override
        public String getLabel() {
            return "";
        }
    }

    private static class PersonNavigatorWrapper
    extends BaseItemNavigatorLabelWrapper<IPlayer> {
        public PersonNavigatorWrapper(IPlayer item) {
            super(item);
        }

        @Override
        public String getLabel() {
            return ((IPlayer)this.getItem()).getName() + " " + ((IPlayer)this.getItem()).getLastName();
        }
    }

    private static class VesselNavigatorWrapper
    extends BaseItemNavigatorLabelWrapper<INavigableVessel> {
        public VesselNavigatorWrapper(INavigableVessel item) {
            super(item);
        }

        @Override
        public String getLabel() {
            return ((INavigableVessel)this.getItem()).getName();
        }
    }

    private static class ShipNavigatorWrapper
    extends BaseItemNavigatorLabelWrapper<IShip> {
        public ShipNavigatorWrapper(IShip item) {
            super(item);
        }

        @Override
        public String getLabel() {
            return ((IShip)this.getItem()).getName();
        }
    }
}

