/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.javafx.service.AbstractNoticeBoardMenuProvider;
import ch.sahits.game.javafx.service.INoticeBoardMenuProvider;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class NoticeBoardGuildMenuProvider
extends AbstractNoticeBoardMenuProvider
implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private GuildList guildList;

    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<NoticeBoardMenuEntry>();
        IHumanPlayer player = proxy.getPlayer();
        ICity city = proxy.getCity();
        Optional guildOpt = this.guildList.findGuild(city);
        if (guildOpt.isPresent()) {
            NoticeBoardMenuEntry entry;
            String s;
            IGuild guild = (IGuild)guildOpt.get();
            if (!guild.getMembers().contains(player)) {
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.guild.join", new Object[0], this.locale.getCurrentLocal());
                entry = this.createNoticeBoardEntry(s, EDialogType.GUILD_JOIN);
                entries.add(entry);
            }
            if (guild.getMembers().contains(player)) {
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.guild.members", new Object[0], this.locale.getCurrentLocal());
                entry = this.createNoticeBoardEntry(s, EDialogType.GUILD_MEMBERS);
                entries.add(entry);
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.guild.auction", new Object[0], this.locale.getCurrentLocal());
                entry = this.createNoticeBoardEntry(s, EDialogType.GUILD_AUCTION);
                entries.add(entry);
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.guild.tradespots", new Object[0], this.locale.getCurrentLocal());
                entry = this.createNoticeBoardEntry(s, EDialogType.GUILD_MEDITERREAN);
                entries.add(entry);
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.guild.tradeaggreements", new Object[0], this.locale.getCurrentLocal());
                entry = this.createNoticeBoardEntry(s, EDialogType.GUILD_TRADE_AGREEMENT);
                entries.add(entry);
            }
        }
        return entries;
    }
}

