/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.javafx.service.AbstractNoticeBoardMenuProvider;
import ch.sahits.game.javafx.service.INoticeBoardMenuProvider;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class NoticeBoardTradingMenuProvider
extends AbstractNoticeBoardMenuProvider
implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<NoticeBoardMenuEntry>();
        String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.city2ship", new Object[0], this.locale.getCurrentLocal());
        if (proxy.getActiveShip() instanceof IConvoy) {
            s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.city2convoy", new Object[0], this.locale.getCurrentLocal());
        }
        NoticeBoardMenuEntry entry = this.createNoticeBoardEntry(s, EDialogType.PORT_CITY_TO_SHIP);
        entries.add(entry);
        if (!proxy.getCity().findBuilding(ITradingOffice.class, Optional.of(proxy.getPlayer())).isEmpty()) {
            s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.ship2tradingOffice", new Object[0], this.locale.getCurrentLocal());
            if (proxy.getActiveShip() instanceof IConvoy) {
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.convoy2tradingOffice", new Object[0], this.locale.getCurrentLocal());
            }
            entry = this.createNoticeBoardEntry(s, EDialogType.PORT_STORAGE_TO_SHIP);
            entries.add(entry);
            s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.city2tradingOffice", new Object[0], this.locale.getCurrentLocal());
            entry = this.createNoticeBoardEntry(s, EDialogType.PORT_CITY_TO_STORAGE);
            entries.add(entry);
            s = this.messageSource.getMessage("ch.sahits.game.openpatrician.model.people.impl.WeaponsDealerState.noticeboardTitle", new Object[0], this.locale.getCurrentLocal());
            entry = this.createNoticeBoardEntry(s, EDialogType.PORT_WEAPON);
            entry.setDisabled(true);
            entries.add(entry);
        }
        return entries;
    }
}

