/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.util;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.javafx.control.MoneyTransfer;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.DynamicTextTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class JavaFXUtils {
    @Autowired
    private ApplicationContext context;

    public void addCellToGridPane(GridPane grid, int rowNum, TableRow row, int col, ITableCell cell, HPos hAlignment, String textStyleClass) {
        if (cell instanceof StaticTextTableCell) {
            Text text = new Text(((StaticTextTableCell)cell).getValue());
            text.getStyleClass().add((Object)textStyleClass);
            this.addCellToGridPane(rowNum, row, col, cell, (Node)text, grid, hAlignment);
        } else if (cell instanceof DynamicTextTableCell) {
            DynamicTextTableCell dynCell = (DynamicTextTableCell)cell;
            Text text = new Text();
            text.textProperty().bind((ObservableValue)dynCell.valueProperty());
            text.getStyleClass().add((Object)textStyleClass);
            this.addCellToGridPane(rowNum, row, col, cell, (Node)text, grid, hAlignment);
        } else if (cell instanceof ControlTableCell) {
            Node control = ((ControlTableCell)cell).getControl();
            this.addCellToGridPane(rowNum, row, col, cell, control, grid, hAlignment);
        } else {
            throw new RuntimeException("Not implemented");
        }
    }

    private void addCellToGridPane(int rowNum, TableRow row, int col, ITableCell cell, Node node, GridPane grid, HPos halignment) {
        if (row != null && row.hasConstraint(cell)) {
            switch (row.getCellConstraint(cell)) {
                case COLSPAN2: {
                    grid.add(node, col, rowNum + 1, 2, 1);
                    GridPane.setColumnSpan((Node)node, (Integer)2);
                    break;
                }
                case COLSPAN4: {
                    grid.add(node, col, rowNum + 3, 2, 1);
                    GridPane.setColumnSpan((Node)node, (Integer)4);
                    break;
                }
                default: {
                    grid.add(node, col, rowNum + 1);
                    break;
                }
            }
        } else {
            grid.add(node, col, rowNum + 1);
        }
        GridPane.setHalignment((Node)node, (HPos)halignment);
        GridPane.setValignment((Node)node, (VPos)VPos.CENTER);
    }

    public GridPane createGridPaneFromModel(Table model) {
        TableHeader header = model.getHeader();
        GridPane grid = new GridPane();
        RowConstraints rowConstraint = new RowConstraints(48.0);
        grid.getRowConstraints().add((Object)rowConstraint);
        rowConstraint = new RowConstraints(24.0);
        for (int i = 0; i < model.getNumberOfColumns(); ++i) {
            int colWidth = model.getColumnWidth(i);
            ColumnConstraints colConstraint = new ColumnConstraints((double)colWidth);
            colConstraint.setHalignment(header.getAligenment(i));
            grid.getColumnConstraints().add((Object)colConstraint);
            ITableCell cell = header.get(i);
            String textStyleClass = "tableHeader";
            this.addCellToGridPane(grid, -1, null, i, cell, header.getAligenment(i), "tableHeader");
        }
        for (int rowNum = 0; rowNum < model.getNumberOfRows(); ++rowNum) {
            TableRow row = model.get(rowNum);
            grid.getRowConstraints().add((Object)rowConstraint);
            int iterationLimit = Math.min(model.getNumberOfColumns(), row.size());
            for (int col = 0; col < iterationLimit; ++col) {
                ITableCell cell = row.get(col);
                HPos hAlignment = model.getAligenment(col);
                String textStyleClass = "tableCell";
                this.addCellToGridPane(grid, rowNum, row, col, cell, hAlignment, "tableCell");
            }
        }
        grid.setHgap(5.0);
        return grid;
    }

    public MoneyTransfer getMoneyTransfer(IDataImageLoader imageLoader) {
        return new MoneyTransfer(imageLoader);
    }
}

