package ch.sahits.game.javafx;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.Region;
import lombok.Getter;

/**
 * The open patrician scene stores the dimensions of the scene.
 * Thereby the dimensions of the stage can be bound the scene and the
 * scene can react on size changes.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jul 20, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianScene {
	@Getter
	private final Region root;
	

//	public OpenPatricianScene(Parent root, double width, double height,
//			boolean depthBuffer) {
//		super(root, width, height, depthBuffer);
//		registerSizeChanges();
//	}
//
//	public OpenPatricianScene(Parent root, double width, double height,
//			Paint fill) {
//		super(root, width, height, fill);
//		registerSizeChanges();
//	}

	public OpenPatricianScene(Region root) {
		this.root = root;
		registerSizeChanges();
	}

//	public OpenPatricianScene(Parent root, Paint fill) {
//		super(root, fill);
//		registerSizeChanges();
//	}

//	public OpenPatricianScene(Parent root) {
//		super(root);
//		registerSizeChanges();
//	}

	
	private void registerSizeChanges() {
		root.widthProperty().addListener(new ChangeListener<Number>() {
		    @Override public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneWidth, Number newSceneWidth) {
		        widthChange((Double)oldSceneWidth, (Double)newSceneWidth);
		    }
		});
		root.heightProperty().addListener(new ChangeListener<Number>() {
		    @Override public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneHeight, Number newSceneHeight) {
		        heightChange((Double)oldSceneHeight, (Double)newSceneHeight);
		    }
		});
	}
	/**
	 * Method that is called when the height of the scene changes. Subclasses that need
	 * to be aware of size changes should override this method.
	 * @param oldHeight old height of the scene
	 * @param newHeigth new height of the scene
	 */
	public void heightChange(double oldHeight, double newHeigth) {
	}
	
	/**
	 * Method that is called when the width of the scene changes. Subclasses that need
	 * to be aware of size changes should override this method.
	 * @param oldWidth old width of the scene
	 * @param newWidth new width of the scene
	 */
	public void widthChange(double oldWidth, double newWidth) {
	}

}
