package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.control.skin.EventMediaPlayerSkin;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.event.EEventMediaType;
import javafx.beans.property.*;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import lombok.Getter;

import java.net.URL;

/**
 * Control for playing an event video.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 *         Created on Jan 04, 2017
 */
@ClassCategory(EClassCategory.JAVAFX)
public class EventMediaPlayer extends Control {

    private StringProperty title = new SimpleStringProperty();
    private StringProperty description = new SimpleStringProperty();
    private BooleanProperty stopped = new SimpleBooleanProperty(false);
    @Getter
    private final EEventMediaType type;

    private final ReadOnlyDoubleProperty parentWidth;

    public EventMediaPlayer(EEventMediaType media, ReadOnlyDoubleProperty parentWidth) {
        this.parentWidth = parentWidth;
        this.type = media;
        this.getStyleClass().add("root");

    }
    @Override
    public String getUserAgentStylesheet() {
        URL cssURL = getClass().getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
        return cssURL.toExternalForm();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new EventMediaPlayerSkin(this, parentWidth);
    }

    public String getTitle() {
        return title.get();
    }

    public StringProperty titleProperty() {
        return title;
    }

    public void setTitle(String title) {
        this.title.set(title);
    }

    public String getDescription() {
        return description.get();
    }

    public StringProperty descriptionProperty() {
        return description;
    }

    /**
     * Set the description for the event.
     * @param description
     */
    public void setDescription(String description) {
        this.description.set(description);
    }

    public BooleanProperty stoppedProperty() {
        return stopped;
    }

    public void stop() {
        this.stopped.set(true);
    }
}
