package ch.sahits.game.javafx.control;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.javafx.control.skin.MoneyTransferSkin;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

import java.net.URL;

/**
 * Input control to transfer money. This control allows the amount to be transfered to be increased or decreased.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jul 12, 2015
 */
@ClassCategory(EClassCategory.JAVAFX)
public class MoneyTransfer extends Control {
    private IntegerProperty stepSize = new SimpleIntegerProperty(1);
    private IntegerProperty amount = new SimpleIntegerProperty(0);
    private IntegerProperty maxTransfereable = new SimpleIntegerProperty(0);
    private MoneyTransferSkin skin;

    private final IDataImageLoader imageLoader;

    public MoneyTransfer(IDataImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    public int getStepSize() {
        return stepSize.get();
    }

    public IntegerProperty stepSizeProperty() {
        return stepSize;
    }

    public void setStepSize(int stepSize) {
        this.stepSize.set(stepSize);
    }

    public int getAmount() {
        return amount.get();
    }

    public IntegerProperty amountProperty() {
        return amount;
    }

    public void setAmount(int amount) {
        this.amount.set(amount);
    }

    public int getMaxTransfereable() {
        return maxTransfereable.get();
    }

    public IntegerProperty maxTransfereableProperty() {
        return maxTransfereable;
    }

    public void setMaxTransfereable(int maxTransfereable) {
        this.maxTransfereable.set(maxTransfereable);
    }
    @Override
    public String getUserAgentStylesheet() {
        URL cssURL = getClass().getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
        return cssURL.toExternalForm();
    }

    @Override
    public Skin<?> createDefaultSkin() {
        skin = new MoneyTransferSkin(this, imageLoader);
        return skin;
    }

    @Override
    public ObservableList<Node> getChildrenUnmodifiable() {
        if (skin != null) {
            return FXCollections.unmodifiableObservableList(skin.getChildren());
        } else {
            return super.getChildrenUnmodifiable();
        }
    }
}
