package ch.sahits.game.javafx.control;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Base class for buttons in openPatricain.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 14, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianButton extends Control {

	protected final StringProperty text;
	@ObjectPropertyType(EventHandler.class)
	protected final ObjectProperty<EventHandler<MouseEvent>> onAction;
	@ObjectPropertyType(Font.class)
	private StyleableObjectProperty<Font> font;

	public OpenPatricianButton(String text) {
		super();
		this.text = new SimpleStringProperty(this, "text", text);
		this.onAction = new SimpleObjectProperty<EventHandler<MouseEvent>>(this, "onAction");
		this.getStyleClass().add(this.getClass().getSimpleName());
	}

	@Override
	public String getUserAgentStylesheet() {
	    URL cssURL = getClass().getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
		return cssURL.toExternalForm();
	}

	public StringProperty textProperty() {
		return text;
	}

	public String getText() {
		return text.get();
	}

	public void setText(String text) {
		this.text.set(text);
	}


	public ObjectProperty<EventHandler<MouseEvent>> onActionProperty() {
		return onAction;
	}

	public EventHandler<MouseEvent> getOnAction() {
		return onAction.get();
	}

	public void setOnAction(EventHandler<MouseEvent> onAction) {
		this.onAction.set(onAction);
	}


	public Font getFont() {
		return font == null ? Font.getDefault() : font.get();
	}

	public void setFont(Font font) {
		this.font.set(font);
	}

	public StyleableObjectProperty<Font> fontProperty() {
		if (font == null) {
			font = new SimpleStyleableObjectProperty<Font>(StyleableProperties.FONT, OpenPatricianButton.this, "font", Font.getDefault());
		}
		return font;
	}

	private static class StyleableProperties {
		private static final CssMetaData<OpenPatricianButton, Font> FONT =
				new CssMetaData<OpenPatricianButton, Font>("-fx-font",
						StyleConverter.getFontConverter(), Font.getDefault()) {
					@Override
					public boolean isSettable(OpenPatricianButton control) {
						return control.font == null || !control.font.isBound();
					}

					@Override
					public StyleableProperty<Font> getStyleableProperty(OpenPatricianButton control) {
						return control.fontProperty();
					}
				};
		private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

		static {
			final List<CssMetaData<? extends Styleable, ?>> styleables =
					new ArrayList<CssMetaData<? extends Styleable, ?>>(Control.getClassCssMetaData());
			Collections.addAll(styleables,
					FONT
			);
			STYLEABLES = Collections.unmodifiableList(styleables);
		}
	}

	public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
		return getClassCssMetaData();
	}

	public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
		return StyleableProperties.STYLEABLES;
	}
}