package ch.sahits.game.javafx.control;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.scene.Node;
import javafx.scene.control.Label;

import java.net.URL;
/**
 * OpenPatrician styled Label.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 20, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianLabel extends Label {

	public OpenPatricianLabel() {
		super();
		initializeStyle();
	}

	private void initializeStyle() {
		Class<? extends OpenPatricianLabel> clazz = this.getClass();
		URL cssURL = clazz.getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
		getStylesheets().add(cssURL.toExternalForm());
		getStyleClass().addAll("openPatricianLabel");
	}

	public OpenPatricianLabel(String arg0, Node arg1) {
		super(arg0, arg1);
		initializeStyle();
	}

	public OpenPatricianLabel(String arg0) {
		super(arg0);
		initializeStyle();
	}

}
