package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.control.skin.OpenPatricianSpinnerSkin;
import ch.sahits.game.javafx.model.OpenPatricianSpinnerOptionDataModel;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.text.Font;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
/**
 * Open patrician spinner class.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 23, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianSpinner extends Control {
    /** The display options */
	private final ListProperty<OpenPatricianSpinnerOptionDataModel> options;
//    /** Mapping the options to additional data */
//	@MapType(key=String.class, value = String.class)
//    private Map<String,T> optionsMap; // use generic type

	private final IntegerProperty selectedIndex;
	@ObjectPropertyType(Font.class)
	private StyleableObjectProperty<Font> font;


	public OpenPatricianSpinner() {
		options = new SimpleListProperty<>(this, "options", FXCollections.observableList(new ArrayList<OpenPatricianSpinnerOptionDataModel>()));
		selectedIndex = new SimpleIntegerProperty(this, "selectedIndex", -1);
		this.getStyleClass().add(this.getClass().getSimpleName());
	}

	@Override
	public String getUserAgentStylesheet() {
        URL cssURL = getClass().getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
		return cssURL.toExternalForm();
	}

	@Override
	protected Skin<?> createDefaultSkin() {
		return new OpenPatricianSpinnerSkin(this);
	}

	public ListProperty<OpenPatricianSpinnerOptionDataModel> optionsProperty() {
		return options;
	}
	public ObservableList<OpenPatricianSpinnerOptionDataModel> getOptions() {
		return options.get();
	}

	public void setOptions(ObservableList<OpenPatricianSpinnerOptionDataModel> options) {
		this.options.set(options);
	}

	public IntegerProperty selectedIndexProperty() {
		return selectedIndex;
	}
	public int getSelectedIndex() {
		return selectedIndex.get();
	}
	
	public void incSelectedIndex() {
		if (selectedIndex.getValue() < getOptions().size() -1) {
			selectedIndex.set(getSelectedIndex()+1);
		}
	}
	public void decSelectedIndex() {
		if (selectedIndex.getValue() > 0) {
			selectedIndex.set(getSelectedIndex()-1);
		}
	}

//    /**
//     * Set the options with their mapping values.
//     * @param optionsMap .
//     */
//    public void setOptionsMap(Map<String,T> optionsMap) {
//        this.options.clear();
//        this.options.setAll(optionsMap.keySet());
//        this.optionsMap = optionsMap;
//
//    }

    /**
     * Retrieve the mapping value for the selected index.
     * @return selected mapped value.
     */
    public String getSelectedValue() {
        return options.get(getSelectedIndex()).getValue();
    }


	public Font getFont() {
		return font == null ? Font.getDefault() : font.get();
	}

	public void setFont(Font font) {
		this.font.set(font);
	}

	public StyleableObjectProperty<Font> fontProperty() {
		if (font == null) {
			font = new SimpleStyleableObjectProperty<>(StyleableProperties.FONT, OpenPatricianSpinner.this, "font", Font.getDefault());
		}
		return font;
	}

	private static class StyleableProperties {
		private static final CssMetaData<OpenPatricianSpinner, Font> FONT =
				new CssMetaData<OpenPatricianSpinner, Font>("-fx-font",
						StyleConverter.getFontConverter(), Font.getDefault()) {
					@Override
					public boolean isSettable(OpenPatricianSpinner control) {
						return control.font == null || !control.font.isBound();
					}

					@Override
					public StyleableProperty<Font> getStyleableProperty(OpenPatricianSpinner control) {
						return control.fontProperty();
					}
				};
		private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

		static {
			final List<CssMetaData<? extends Styleable, ?>> styleables =
					new ArrayList<>(Control.getClassCssMetaData());
			Collections.addAll(styleables,
					FONT
			);
			STYLEABLES = Collections.unmodifiableList(styleables);
		}
	}

	public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
		return getClassCssMetaData();
	}

	public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
		return StyleableProperties.STYLEABLES;
	}
}
