package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.control.skin.OpenPatricianWoodenTextInputSkin;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.text.Font;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Open patrician wood input field.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 23, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianWoodenTextInput extends Control {
	
	private final StringProperty text;
	private final IntegerProperty size;
	private StyleableObjectProperty<Font> font;

	/**
	 * Initialize the initial text.
	 * @param text
	 */
	public OpenPatricianWoodenTextInput(String text) {
		super();
		this.text = new SimpleStringProperty(this, "text", text);
		size = new SimpleIntegerProperty(this, "size", 25);
		this.getStyleClass().add(this.getClass().getSimpleName());
	}
	
	
	@Override
	public String getUserAgentStylesheet() {
        URL cssURL = getClass().getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
		return cssURL.toExternalForm();
	}

	@Override
	protected Skin<?> createDefaultSkin() {
		return new OpenPatricianWoodenTextInputSkin(this);
	}

	public StringProperty textProperty() {
		return text;
	}
	public String getText() {
		return text.get();
	}
	public void setText(String text) {
		this.text.set(text);
	}
	public IntegerProperty sizeProperty() {
		return size;
	}
	public void setSize(int size) {
		this.size.set(size);
	}
	public int getSize() {
		return size.get();
	}
	public Font getFont() {
		return font == null ? Font.getDefault() : font.get();
	}

	public void setFont(Font font) {
		this.font.set(font);
	}

	public StyleableObjectProperty<Font> fontProperty() {
		if (font == null) {
			font = new SimpleStyleableObjectProperty<Font>(StyleableProperties.FONT, OpenPatricianWoodenTextInput.this, "font", Font.getDefault());
		}
		return font;
	}

	private static class StyleableProperties {
		private static final CssMetaData<OpenPatricianWoodenTextInput, Font> FONT =
				new CssMetaData<OpenPatricianWoodenTextInput, Font>("-fx-font",
						StyleConverter.getFontConverter(), Font.getDefault()) {
					@Override
					public boolean isSettable(OpenPatricianWoodenTextInput control) {
						return control.font == null || !control.font.isBound();
					}

					@Override
					public StyleableProperty<Font> getStyleableProperty(OpenPatricianWoodenTextInput control) {
						return control.fontProperty();
					}
				};
		private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

		static {
			final List<CssMetaData<? extends Styleable, ?>> styleables =
					new ArrayList<CssMetaData<? extends Styleable, ?>>(Control.getClassCssMetaData());
			Collections.addAll(styleables,
					FONT
			);
			STYLEABLES = Collections.unmodifiableList(styleables);
		}
	}

	public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
		return getClassCssMetaData();
	}

	public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
		return StyleableProperties.STYLEABLES;
	}
}
