package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.DisplayMessageOverlayLabel;
import ch.sahits.game.javafx.control.TextSizingUtility;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;

import java.io.InputStream;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Mar 08, 2015
 */
public class DisplayMessageOverlayLabelSkin extends SkinBase<DisplayMessageOverlayLabel> {
    private final  DisplayMessageOverlayLabel control;
    private final TextSizingUtility sizing;

    private DoubleProperty textLength = new SimpleDoubleProperty(0);
    private final Image waxBtnMiddle;
    private final double middleSectionWidth;

    public DisplayMessageOverlayLabelSkin(DisplayMessageOverlayLabel control, TextSizingUtility sizing) {
        super(control);
        this.control = control;
        this.sizing = sizing;
        textLength.set(sizing.calculate(control.getText(), control.getFont()).getWidth());
        control.fontProperty().addListener((observable, oldFont, newFont) -> {
            textLength.set(sizing.calculate(control.getText(), newFont).getWidth());
        });
        control.textProperty().addListener((observable, oldText, newText) -> {
            textLength.set(sizing.calculate(newText, control.getFont()).getWidth());
        });
        InputStream is = getClass().getResourceAsStream("waxButton-middle.png");
        waxBtnMiddle = new Image(is);
        is = getClass().getResourceAsStream("waxButton-left.png");
        Image leftEnd = new Image(is);
        is = getClass().getResourceAsStream("waxButton-right.png");
        Image rightEnd = new Image(is);
        middleSectionWidth = waxBtnMiddle.getWidth();
        BorderPane borderPane = new BorderPane();
        ImageView left = new ImageView(leftEnd);
        ImageView right = new ImageView(rightEnd);
        StackPane middleSection = new StackPane();
        HBox waxButon = new HBox();
        Label label = new Label(control.getText());
        label.getStyleClass().add("display-message-label");
        if (control.isLinkText()) {
            label.getStyleClass().add("display-message-link");
        }
        control.linkTextProperty().addListener((observable, oldFlag, newFlag) -> {
            if (newFlag && oldFlag != newFlag) {
                label.getStyleClass().add("display-message-link");
            } else {
                label.getStyleClass().remove("display-message-link");
            }
        });
        label.textProperty().bind(control.textProperty());
        int nbSegments = (int)Math.ceil(textLength.getValue()/middleSectionWidth);
        for (int i=0; i<nbSegments; i++) {
            waxButon.getChildren().add(new ImageView(waxBtnMiddle));
        }
        middleSection.getChildren().addAll(waxButon, label);
        textLength.addListener((observable, oldWidth, newWidth) -> {
            int numberSegments = (int)Math.ceil(newWidth.doubleValue()/middleSectionWidth);
            waxButon.getChildren().clear();
            for (int i=0; i<numberSegments; i++) {
                waxButon.getChildren().add(new ImageView(waxBtnMiddle));
            }
        });
        borderPane.setLeft(left);
        borderPane.setRight(right);
        borderPane.setCenter(middleSection);
        getChildren().addAll(borderPane);
    }
}
