package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.ImageFactory;
import ch.sahits.game.javafx.control.OpenPatricianButton;
import ch.sahits.game.javafx.control.OpenPatricianStoneButton;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;

/**
 * Skin for the open patrician stone button.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 23, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianStoneButtonSkin extends SkinBase<OpenPatricianStoneButton> {

	private final ImageView imageView;
	private final OpenPatricianButton button;

	public OpenPatricianStoneButtonSkin(final OpenPatricianStoneButton button) {
		super(button);
		this.button = button;
		
		
		Dimension2D dim = calculateButtonDimensions(button);
		ImageFactory imageFactory = new ImageFactory();
		Image img = imageFactory.getSlabImage(dim);
		imageView = new ImageView(img);

		button.fontProperty().addListener((observable, oldvalue, newValue) -> {
			calculateNewDimensions();
		});
		
		final Label label = new Label(button.getText()); 
		label.onMouseClickedProperty().bind(button.onActionProperty());
		imageView.onMouseReleasedProperty().bind(button.onActionProperty());
		button.textProperty().addListener((observable, oldValue, newValue) -> {
            calculateNewDimensions();
        });
		
		StackPane stack = new StackPane();
		stack.getChildren().addAll(imageView, label);
		Group group = new Group(stack);
		
		group.setManaged(false);
		
		getChildren().add(group);
	}

	private void calculateNewDimensions() {
		Dimension2D dim = calculateButtonDimensions(button);
		// add padding
		ImageFactory imageFactory = new ImageFactory();
		Image img = imageFactory.getSlabImage(dim);
		imageView.setImage(img);
	}

	private Dimension2D calculateButtonDimensions(
			final OpenPatricianButton button) {
		Dimension2D dim = new TextSizingUtility().calculate(button.getText(), button.getFont());
		return new Dimension2D(dim.getWidth()*1.2, dim.getHeight()*1.2);
	}

}
