package ch.sahits.game.javafx.effects.transform;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;

/**
 * Definition of a 2D translation transformation. A 2D point is moved from a
 * source location to a destination location.
 * @author andi
 */
@ClassCategory(EClassCategory.TEST)
public class Translation2D {
    private final ReadOnlyObjectProperty<Point2D> source;
    private final ReadOnlyObjectProperty<Point2D> destination;
    /**
     * Initialize the object using two 2D points.
     * @param source point
     * @param destination point
     */
    public Translation2D(Point2D source, Point2D destination) {
        this.source = new SimpleObjectProperty<>(this, "source", source);
        this.destination = new SimpleObjectProperty<>(this, "destination", destination);
    }
    /**
     * Initialize the object using coordinates for the source and destination
     * @param srcX X-coordinate of the source point
     * @param srcY Y-coordinate of the source point
     * @param destX X-coordinate of the destination point
     * @param destY Y-coordinate of the destination point
     */
    public Translation2D(double srcX, double srcY, double destX, double destY) {
        this(new Point2D(srcX, srcY), new Point2D(destX, destY));
    }
    /**
     * Get the source point.
     * @return .
     */
    public Point2D getSource() {
        return source.getValue();
    }
    /**
     * Get the destination point.
     * @return .
     */
    public Point2D getDestination() {
        return destination.getValue();
    }
    /**
     * Property containing the source point.
     * @return .
     */
    public ReadOnlyObjectProperty<Point2D> sourceProperty() {
        return source;
    }
    /**
     * Property containing the destination point.
     * @return .
     */
    public ReadOnlyObjectProperty<Point2D> destinationProperty() {
        return destination;
    }
    
}
