package ch.sahits.game.javafx.model;

import lombok.Getter;

/**
 * The various types of the notice board. There are sub types that allow
 * defining behavior tied to the fact if the notice board
 * is tied to a scene or not.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
public enum ENoticeBoardType {
    MESSAGE(false, true),
    SHIPYARD(true, false),
    TAVERN(true, true),
    TRADING(true, false),
    LOANER(true, false),
    TRADING_OFFICE(true, false),
    SHIP_SELECTION(true, false),
    MARKET_PLACE(true, false),
    CHURCH(true, false),
    CITY_HALL_NOTICE_BOARD(true, false),
    CITY_HALL_MAYORS_OFFICE(true, false),
    CITY_HALL_ALDERMAN_OFFICE(true, false),
    CITY_HALL_MEETINGROOM(true, false),
    GUILD(true, false);
    /** Indicates if this type is bound to a certain scene */
    @Getter
    private final boolean tiedToScene;
    /** Indicates if the content may change dynamically */
    @Getter
    private final boolean dynamic;

    ENoticeBoardType(boolean tiedToScene, boolean dynamic) {
        this.tiedToScene = tiedToScene;
        this.dynamic = dynamic;
    }
}
