package ch.sahits.game.javafx.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import javafx.geometry.HPos;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
/**
 * Table model.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 16, 2013
 *
 */
@ClassCategory(EClassCategory.MODEL)
public class Table implements Iterable<TableRow>{

	private TableHeader header;
	@ListType(TableRow.class)
	private List<TableRow> rows;
	private Integer[] columnWidth;
	private RowCellAlignement alignment;
	
	public Table() {
		rows = new ArrayList<>();
		columnWidth = new Integer[0];
	}
	
	public TableHeader getHeader() {
		return header;
	}
	public void setHeader(TableHeader header) {
		this.header = header;
		alignment = new RowCellAlignement(header.getNbCols());
	}
	public void add(TableRow row) {
		rows.add(row);
	}
	public TableRow get(int index) {
		return rows.get(index);
	}
	@Override
	public Iterator<TableRow> iterator() {
		return rows.iterator();
	}
	/**
	 * Return the number of columns based on the header.
	 * @return
	 */
	public int getNumberOfColumns(){
		return header != null ? header.getNbCols() : 0;
	}
	/**
	 * Return the number of rows, not counting the header.
	 * @return
	 */
	public int getNumberOfRows() {
		return rows.size();
	}
	/**
	 * Calculate the width of the indicated column.
	 * @param column
	 * @return
	 */
	public int getColumnWidth(int column) {
		if (column < columnWidth.length) {
			return columnWidth[column];
		} else {
			return 0;
		}
	}
	public void setColumnWidth(Integer...columnWidth) {
		this.columnWidth = columnWidth;
	}

	public void setAligenment(int index, HPos pos) {
		alignment.setAligenment(index, pos);
	}

	public HPos getAligenment(int column) {
		return alignment.getAligenment(column);
	}
	
}
