package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.TreeSet;

/**
 * Provide items for the trading menu.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 19, 2015
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class NoticeBoardTradingMenuProvider extends AbstractNoticeBoardMenuProvider implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<>();

        String s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.city2ship", new Object[]{}, locale.getCurrentLocal());
        if (proxy.getActiveShip() instanceof IConvoy){
            s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.city2convoy", new Object[]{}, locale.getCurrentLocal());
        }
        NoticeBoardMenuEntry entry = createNoticeBoardEntry(s, EDialogType.PORT_CITY_TO_SHIP);
        entries.add(entry);

        if (!proxy.getCity().findBuilding(ITradingOffice.class, Optional.of(proxy.getPlayer())).isEmpty()) {
            s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.ship2tradingOffice", new Object[]{}, locale.getCurrentLocal());
            if (proxy.getActiveShip() instanceof IConvoy) {
                s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.convoy2tradingOffice", new Object[]{}, locale.getCurrentLocal());
            }
            entry = createNoticeBoardEntry(s, EDialogType.PORT_STORAGE_TO_SHIP);
            entries.add(entry);

            s = messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.city2tradingOffice", new Object[]{}, locale.getCurrentLocal());
            entry = createNoticeBoardEntry(s, EDialogType.PORT_CITY_TO_STORAGE);
            entries.add(entry);

            s = messageSource.getMessage("ch.sahits.game.openpatrician.model.people.impl.WeaponsDealerState.noticeboardTitle", new Object[]{}, locale.getCurrentLocal());
            entry = createNoticeBoardEntry(s, EDialogType.PORT_WEAPON);
            entry.setDisabled(true);
            entries.add(entry);
        }

        return entries;
    }
}
