/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.model.ENoticeBoardType;
import ch.sahits.game.javafx.service.NoticeBoardMenuTitleProvider;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import ch.sahits.game.test.JavaFXThreadingRule;
import javafx.scene.control.Label;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.context.MessageSource;

@RunWith(value=MockitoJUnitRunner.class)
public class NoticeBoardMenuTitleProviderTest {
    @Rule
    public JavaFXThreadingRule jfxRule = new JavaFXThreadingRule();
    @Mock
    private Locale locale;
    @Mock
    private MessageSource messageSource;
    @InjectMocks
    private NoticeBoardMenuTitleProvider titleProvider;

    @Before
    public void setup() {
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)java.util.Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class))).willReturn((Object)"non empty string");
    }

    @Test
    public void shouldProvideTitleForAllNoticeBoardTypes() {
        for (ENoticeBoardType types : ENoticeBoardType.values()) {
            Label lbl = this.titleProvider.createTitle(types);
            Assert.assertFalse((boolean)lbl.getText().equals(""));
        }
    }
}

