/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.service;

import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.javafx.model.DisplayMessages;
import ch.sahits.game.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.service.NoticeBoardMessageMenuProvider;
import ch.sahits.game.javafx.service.TextEllipsisCalculator;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.model.DisplayTemplateMessage;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.LinkedHashSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.text.Font;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@RunWith(value=MockitoJUnitRunner.class)
public class NoticeBoardMessageMenuProviderTest {
    @Mock
    private DisplayMessages displayMessages;
    @Mock
    private ModelTranslations translator;
    @Mock
    private Locale locale;
    @Mock
    private MessageSource messageSource;
    @Mock
    private TextEllipsisCalculator ellipsisCalculator;
    @Mock
    private DecoratedTextFactory textFactory;
    @Mock
    private TextSizingUtility sizeing;
    @Mock
    private ApplicationContext context;
    @InjectMocks
    private NoticeBoardMessageMenuProvider messageMenuProvider;

    @Test
    public void shouldCreateMessageItems() {
        DisplayTemplateMessage msg1 = new DisplayTemplateMessage("someKey", (DialogTemplate)Mockito.mock(DialogTemplate.class), new Object[]{EWare.BEER});
        ObservableList messages = FXCollections.observableArrayList();
        messages.add((Object)msg1);
        BDDMockito.given((Object)this.displayMessages.messagesProperty()).willReturn((Object)messages);
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)java.util.Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (java.util.Locale)Matchers.any(java.util.Locale.class))).willReturn((Object)"some translation");
        BDDMockito.given((Object)this.translator.getLocalDisplayName(EWare.BEER)).willReturn((Object)"Beer");
        BDDMockito.given((Object)this.ellipsisCalculator.calculateEllipsis((Font)Matchers.any(Font.class), Matchers.anyString(), Matchers.anyDouble())).willReturn((Object)"some trans...");
        DecoratedText text = new DecoratedText();
        text.append("some trans...");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText("some trans...")).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeDialogTemplateRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        LinkedHashSet entries = this.messageMenuProvider.createMenuEntries((ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class), null);
        ((ModelTranslations)Mockito.verify((Object)this.translator)).getLocalDisplayName(EWare.BEER);
        ((DisplayMessages)Mockito.verify((Object)this.displayMessages)).messagesProperty();
        ((Locale)Mockito.verify((Object)this.locale)).getCurrentLocal();
        ((MessageSource)Mockito.verify((Object)this.messageSource)).getMessage((String)Matchers.eq((Object)"someKey"), (Object[])Matchers.any(), (java.util.Locale)Matchers.eq((Object)java.util.Locale.ENGLISH));
        ((TextEllipsisCalculator)Mockito.verify((Object)this.ellipsisCalculator)).calculateEllipsis((Font)Matchers.any(Font.class), (String)Matchers.eq((Object)"some translation"), Matchers.anyDouble());
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory)).createSimpleDecoratedText("some trans...");
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean((String)Matchers.eq((Object)"viewChangeDialogTemplateRunnable"), (Object[])Matchers.any(Object[].class));
        Assert.assertEquals((long)1L, (long)entries.size());
        NoticeBoardMenuEntry entry = (NoticeBoardMenuEntry)entries.iterator().next();
        Assert.assertNotNull((Object)entry.getLabel());
        Assert.assertNotNull((Object)entry.getLabel().getOnMouseEntered());
        Assert.assertNotNull((Object)entry.getLabel().getOnMouseExited());
    }
}

