package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.javafx.control.skin.OpenPatricianRadioButtonSkin;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Skin;

import java.net.URL;

/**
 * OpenPatrician radio button.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 23, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianRadioButton extends RadioButton {
	
	private final StringProperty selectedLabel;
	private final StringProperty unselectedLabel;



	public OpenPatricianRadioButton(String text) {
		super(text);
		selectedLabel = new SimpleStringProperty(this, "selectedLabel", "yes");
		unselectedLabel = new SimpleStringProperty(this, "unselectedLabel", "no");
		this.getStyleClass().add(this.getClass().getSimpleName());
	}

	@Override
	public String getUserAgentStylesheet() {
        URL cssURL = getClass().getResource("/ch/sahits/game/openpatrician/javafx/control/"+getClass().getSimpleName()+".css");
		return cssURL.toExternalForm();
	}

	@Override
	protected Skin<?> createDefaultSkin() {
		return new OpenPatricianRadioButtonSkin(this);
	}

	public StringProperty selectedLabelProperty() {
		return selectedLabel;
	}
	public void setSelectedLabel(String label) {
		selectedLabel.set(label);
	}
	public String getSelectedLabel() {
		return selectedLabel.get();
	}
	public StringProperty unselectedLabelProperty() {
		return unselectedLabel;
	}
	public void setUnselectedLabel(String label) {
		unselectedLabel.set(label);
	}
	public String getUnselectedLabel() {
		return unselectedLabel.get();
	}
}
