package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.javafx.control.skin.OpenPatricianSmallToggableWaxButtonSkin;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.Skin;

import java.net.URL;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 16, 2015
 */
@ClassCategory(EClassCategory.JAVAFX)
public class OpenPatricianSmallToggableWaxButton extends OpenPatricianSmallWaxButton {

    private BooleanProperty toggled = new SimpleBooleanProperty(false);
    public OpenPatricianSmallToggableWaxButton(String text) {
        super(text);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new OpenPatricianSmallToggableWaxButtonSkin(this);
    }
    public boolean getToggled() {
        return toggled.get();
    }

    public BooleanProperty toggledProperty() {
        return toggled;
    }

    public void setToggled(boolean toggled) {
        this.toggled.set(toggled);
    }
    @Override
    public String getUserAgentStylesheet() {
        URL cssURL = getClass().getResource("/ch/sahits/game/openpatrician/javafx/control/"+getClass().getSuperclass().getSimpleName()+".css");
        return cssURL.toExternalForm();
    }
}
