package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 23, 2015
 */
@ClassCategory({EClassCategory.JAVAFX})
public class TogglebleImageButton extends ImageView {
    private final Image inactiveImage;
    private final Image activeImage;
    private final BooleanProperty active = new SimpleBooleanProperty(false);

    public TogglebleImageButton(Image inactiveImage, Image activeImage) {
        this.inactiveImage = inactiveImage;
        this.activeImage = activeImage;
        setImage(inactiveImage);


        active.addListener((observable, oldValue, newValue) -> {
            if (newValue) {
                setImage(activeImage);
            } else {
                setImage(inactiveImage);
            }
        });
    }

    public void toggle() {
        active.setValue(active.not().get());
    }

    public boolean getActive() {
        return active.get();
    }

    public BooleanProperty activeProperty() {
        return active;
    }
}
