package ch.sahits.game.openpatrician.javafx.control.skin;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.javafx.control.MoneyTransfer;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;

/**
 * Skin for the money transfer control.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jul 12, 2015
 */
public class MoneyTransferSkin extends SkinBase<MoneyTransfer> {
    private final MoneyTransfer moneyTranfer;
    private final IDataImageLoader imageLoader;


    /**
     * Constructor for all SkinBase instances.
     *
     * @param control The control for which this Skin should attach to.
     * @param imageLoader
     */
    public MoneyTransferSkin(MoneyTransfer control, IDataImageLoader imageLoader) {
        super(control);
        moneyTranfer = control;
        this.imageLoader = imageLoader;
        initialzeComponents();
    }

    private void initialzeComponents() {
        HBox selectionBox = new HBox(5);


        final Label input = new Label();
        input.setId("transferLabel");
        input.textProperty().bind(moneyTranfer.amountProperty().asString());

        Image img = imageLoader.getImage("icons/minusIcon");
        ImageView imgView = new ImageView(img);
        imgView.setId("minusIcon");
        imgView.setOnMouseReleased((e) -> {
            int value = Integer.parseInt(input.getText());
            moneyTranfer.setAmount(Math.max(value - moneyTranfer.getStepSize(), 0));
//            input.setText(String.valueOf(Math.max(value - moneyTranfer.getStepSize(), 0)));
        });

        selectionBox.getChildren().addAll(imgView, input);

        img = imageLoader.getImage("icons/coin_icon", 32, 32);
        imgView = new ImageView(img);

        selectionBox.getChildren().add(imgView);

        img = imageLoader.getImage("icons/plusIcon");
        imgView = new ImageView(img);
        imgView.setId("plusIcon");

        selectionBox.getChildren().add(imgView);

        imgView.setOnMouseReleased((e) -> {
            int value = Integer.parseInt(input.getText());
            moneyTranfer.setAmount(Math.min(value + moneyTranfer.getStepSize(), moneyTranfer.getMaxTransfereable()));
//            input.setText(String.valueOf(Math.min(value + moneyTranfer.getStepSize(), moneyTranfer.getMaxTransfereable())));
        });

        getChildren().add(selectionBox);

    }
}
