package ch.sahits.game.openpatrician.javafx.model;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.geometry.Point2D;
import lombok.RequiredArgsConstructor;

/**
 * This data class presents a point and two control points
 * that can be used to add a CubicCurve  to a Bèzier path.
 * This data model can be used in conjunction with CurveTo, where
 * the start point of the cubic curve is the current point of the path.
 * <code>controlPoint1</code> belongs to that point and defines the outgoing
 * of the curve. <code>point</code> is the end point of the curve and <code>controlPoint2</code>
 * defines the incoming of the curve.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jan 06, 2016
 */
@RequiredArgsConstructor
@ClassCategory(EClassCategory.MODEL)
public class BezierCurveControls {
    private final Point2D point;
    private final Point2D controlPoint1;
    private final Point2D controlPoint2;

    /**
     * Retrieve the enpoint of the curve.
     * @return endpoint
     */
    public Point2D getPoint() {
        return point;
    }

    /**
     * Retrieve the outgoing control point for
     * the start point of this segment of the curve.
     * @return control point for the current position on the path.
     */
    public Point2D getControlPoint1() {
        return controlPoint1;
    }

    /**
     * Retrieve the incoming control point for
     * the end point of this segment of the curve.
     * @return control point for <code>point</code>
     */
    public Point2D getControlPoint2() {
        return controlPoint2;
    }
}
