package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import java.util.LinkedHashSet;
import java.util.Optional;

/**
 * Provide menu items for the guild notice board.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 19, 2016
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class NoticeBoardGuildMenuProvider extends AbstractNoticeBoardMenuProvider implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private GuildList guildList;

    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<>();
        IPlayer player = proxy.getPlayer();
        ICity city = proxy.getCity();
        Optional<IGuild> guildOpt = guildList.findGuild(city);
        if (guildOpt.isPresent()) {
            IGuild guild = guildOpt.get();

            if (!guild.getMembers().contains(player)) {
                String s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.guild.join", new Object[]{}, locale.getCurrentLocal());
                NoticeBoardMenuEntry entry = createNoticeBoardEntry(s, EDialogType.GUILD_JOIN);
                entries.add(entry);
            }

            if (guild.getMembers().contains(player)) {
                String s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.guild.members", new Object[]{}, locale.getCurrentLocal());
                NoticeBoardMenuEntry entry = createNoticeBoardEntry(s, EDialogType.GUILD_MEMBERS);
                entries.add(entry);

                s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.guild.auction", new Object[]{}, locale.getCurrentLocal());
                entry = createNoticeBoardEntry(s, EDialogType.GUILD_AUCTION);
                entries.add(entry);

                s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.guild.tradespots", new Object[]{}, locale.getCurrentLocal());
                entry = createNoticeBoardEntry(s, EDialogType.GUILD_MEDITERREAN);
                entries.add(entry);

                s = messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.guild.tradeaggreements", new Object[]{}, locale.getCurrentLocal());
                entry = createNoticeBoardEntry(s, EDialogType.GUILD_TRADE_AGREEMENT);
                entries.add(entry);
            }

        }

        return entries;
    }
}
