/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.graphic.image.impl.FontLoader;
import ch.sahits.game.openpatrician.javafx.control.IWordSplitter;
import ch.sahits.game.openpatrician.javafx.control.Line;
import ch.sahits.game.openpatrician.javafx.control.NonAlphaNumWordSplitter;
import ch.sahits.game.openpatrician.javafx.control.Page;
import ch.sahits.game.openpatrician.javafx.control.PageSplitter;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.utilities.model.CenteredLine;
import ch.sahits.game.openpatrician.utilities.model.Heading;
import ch.sahits.game.openpatrician.utilities.model.ITextComponent;
import ch.sahits.game.openpatrician.utilities.model.Paragraph;
import ch.sahits.game.openpatrician.utilities.model.Text;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.text.Font;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PageSplitterTest {
    @Test
    public void shouldApplyPropperStyles() {
        Font font = FontLoader.loadTestFont();
        PageSplitter splitter = new PageSplitter(100.0, 50.0, 0.0, 0.0, font);
        splitter.setWordSplitter((IWordSplitter)new NonAlphaNumWordSplitter());
        Text text = new Text();
        text.addHeading(new Heading("heading"));
        text.addParagraph(new Paragraph("contents"));
        TextSizingUtility sizing = (TextSizingUtility)Mockito.mock(TextSizingUtility.class);
        splitter.overrideTextSizingUtility(sizing);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "heading", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "heading", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "contents", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "contents", Double.MAX_VALUE)).willReturn((Object)10.0);
        List pages = splitter.splitIntoPages(text);
        Assert.assertEquals((long)1L, (long)pages.size());
        Page page = (Page)pages.get(0);
        Assert.assertEquals((long)2L, (long)page.getLines().size());
        Assert.assertEquals((Object)"pagination-heading", (Object)((Line)page.getLines().get(0)).getStyleClass());
        Assert.assertEquals((Object)"pagination-paragraph", (Object)((Line)page.getLines().get(1)).getStyleClass());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldHandleUnknownTextComponent() {
        Font font = FontLoader.loadTestFont();
        PageSplitter splitter = new PageSplitter(100.0, 50.0, 0.0, 0.0, font);
        splitter.setWordSplitter((IWordSplitter)new NonAlphaNumWordSplitter());
        Text text = (Text)Mockito.mock(Text.class);
        ArrayList<1> components = new ArrayList<1>();
        components.add(new ITextComponent(){});
        BDDMockito.given((Object)text.getText()).willReturn(components);
        TextSizingUtility sizing = (TextSizingUtility)Mockito.mock(TextSizingUtility.class);
        splitter.overrideTextSizingUtility(sizing);
        splitter.splitIntoPages(text);
    }

    @Test
    public void shouldWrappAtLineLength() {
        Font font = FontLoader.loadTestFont();
        PageSplitter splitter = new PageSplitter(100.0, 50.0, 0.0, 0.0, font);
        splitter.setWordSplitter((IWordSplitter)new NonAlphaNumWordSplitter());
        Text text = new Text();
        text.addParagraph(new Paragraph("Text with some words"));
        TextSizingUtility sizing = (TextSizingUtility)Mockito.mock(TextSizingUtility.class);
        splitter.overrideTextSizingUtility(sizing);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text", Double.MAX_VALUE)).willReturn((Object)25.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text with", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text with", Double.MAX_VALUE)).willReturn((Object)50.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text with some", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text with some", Double.MAX_VALUE)).willReturn((Object)75.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "some", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "some", Double.MAX_VALUE)).willReturn((Object)25.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "some words", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "some words", Double.MAX_VALUE)).willReturn((Object)50.0);
        List pages = splitter.splitIntoPages(text);
        Assert.assertEquals((long)1L, (long)pages.size());
        Page page = (Page)pages.get(0);
        Assert.assertEquals((long)2L, (long)page.getLines().size());
        Assert.assertEquals((Object)"Text with", (Object)((Line)page.getLines().get(0)).getLine());
        Assert.assertEquals((Object)"some words", (Object)((Line)page.getLines().get(1)).getLine());
    }

    @Test
    public void shouldTrimLines() {
        Font font = FontLoader.loadTestFont();
        PageSplitter splitter = new PageSplitter(100.0, 50.0, 0.0, 0.0, font);
        splitter.setWordSplitter((IWordSplitter)new NonAlphaNumWordSplitter());
        Text text = new Text();
        text.addParagraph(new Paragraph("Text with some words"));
        TextSizingUtility sizing = (TextSizingUtility)Mockito.mock(TextSizingUtility.class);
        splitter.overrideTextSizingUtility(sizing);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text", Double.MAX_VALUE)).willReturn((Object)25.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text with", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text with", Double.MAX_VALUE)).willReturn((Object)50.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text with some", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text with some", Double.MAX_VALUE)).willReturn((Object)75.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "some", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "some", Double.MAX_VALUE)).willReturn((Object)25.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "some words", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "some words", Double.MAX_VALUE)).willReturn((Object)50.0);
        List pages = splitter.splitIntoPages(text);
        Assert.assertEquals((long)1L, (long)pages.size());
        Page page = (Page)pages.get(0);
        Assert.assertEquals((long)2L, (long)page.getLines().size());
        Assert.assertEquals((Object)((Line)page.getLines().get(0)).getLine().trim(), (Object)((Line)page.getLines().get(0)).getLine());
        Assert.assertEquals((Object)((Line)page.getLines().get(1)).getLine().trim(), (Object)((Line)page.getLines().get(1)).getLine());
    }

    @Test
    public void shouldSplitOnMultiplePages() {
        Font font = FontLoader.loadTestFont();
        PageSplitter splitter = new PageSplitter(100.0, 50.0, 0.0, 0.0, font);
        splitter.setWordSplitter((IWordSplitter)new NonAlphaNumWordSplitter());
        Text text = new Text();
        text.addParagraph(new Paragraph("Text with some words"));
        TextSizingUtility sizing = (TextSizingUtility)Mockito.mock(TextSizingUtility.class);
        splitter.overrideTextSizingUtility(sizing);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text", Double.MAX_VALUE)).willReturn((Object)60.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text", Double.MAX_VALUE)).willReturn((Object)25.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text with", Double.MAX_VALUE)).willReturn((Object)60.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text with", Double.MAX_VALUE)).willReturn((Object)50.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text with some", Double.MAX_VALUE)).willReturn((Object)60.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text with some", Double.MAX_VALUE)).willReturn((Object)75.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "some", Double.MAX_VALUE)).willReturn((Object)60.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "some", Double.MAX_VALUE)).willReturn((Object)25.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "some words", Double.MAX_VALUE)).willReturn((Object)60.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "some words", Double.MAX_VALUE)).willReturn((Object)50.0);
        List pages = splitter.splitIntoPages(text);
        Assert.assertEquals((long)2L, (long)pages.size());
        Page page = (Page)pages.get(0);
        Assert.assertEquals((long)1L, (long)page.getLines().size());
        Assert.assertEquals((Object)"Text with", (Object)((Line)page.getLines().get(0)).getLine());
        page = (Page)pages.get(1);
        Assert.assertEquals((long)1L, (long)page.getLines().size());
        Assert.assertEquals((Object)"some words", (Object)((Line)page.getLines().get(0)).getLine());
    }

    @Test
    public void shouldAddCenteredLineThatTooLong() {
        Font font = FontLoader.loadTestFont();
        PageSplitter splitter = new PageSplitter(50.0, 100.0, 0.0, 0.0, font);
        splitter.setWordSplitter((IWordSplitter)new NonAlphaNumWordSplitter());
        Text text = new Text();
        text.addCenteredLine(new CenteredLine("word word word word word"));
        TextSizingUtility sizing = (TextSizingUtility)Mockito.mock(TextSizingUtility.class);
        splitter.overrideTextSizingUtility(sizing);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "word", Double.MAX_VALUE)).willReturn((Object)20.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "word", Double.MAX_VALUE)).willReturn((Object)24.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "word word", Double.MAX_VALUE)).willReturn((Object)20.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "word word", Double.MAX_VALUE)).willReturn((Object)48.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "word word word", Double.MAX_VALUE)).willReturn((Object)20.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "word word word", Double.MAX_VALUE)).willReturn((Object)72.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "word word word word", Double.MAX_VALUE)).willReturn((Object)20.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "word word word word", Double.MAX_VALUE)).willReturn((Object)96.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "word word word word word", Double.MAX_VALUE)).willReturn((Object)20.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "word word word word word", Double.MAX_VALUE)).willReturn((Object)120.0);
        List pages = splitter.splitIntoPages(text);
        Assert.assertEquals((long)1L, (long)pages.size());
        Page page = (Page)pages.get(0);
        Assert.assertEquals((long)2L, (long)page.getLines().size());
        Line line1 = (Line)page.getLines().get(0);
        Line line2 = (Line)page.getLines().get(1);
        Assert.assertEquals((Object)"word word word word", (Object)line1.getLine());
        Assert.assertEquals((Object)"word", (Object)line2.getLine());
    }
}

