/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.graphic.image.impl.FontLoader;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.testutilities.JavaFXThreadingRule;
import javafx.geometry.Dimension2D;
import javafx.scene.text.Font;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TextSizingUtilityTest {
    @Rule
    public JavaFXThreadingRule javafxRule = new JavaFXThreadingRule();
    private Font font18;
    private Font font24;
    private TextSizingUtility sizing;

    @Before
    public void setup() {
        FontLoader fontLoader = new FontLoader();
        this.font18 = fontLoader.createDefaultFont(18);
        this.font24 = fontLoader.createDefaultFont(24);
        this.sizing = new TextSizingUtility();
    }

    @Test
    public void biggerFontsShouldHaveGreaterHeigth() {
        String text = "OpenPatrician";
        int wrappingWidth = 100;
        double height18 = this.sizing.computeTextHeight(this.font18, text, (double)wrappingWidth);
        double height24 = this.sizing.computeTextHeight(this.font24, text, (double)wrappingWidth);
        MatcherAssert.assertThat((Object)height24, (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(height18)));
    }

    @Test
    public void shouldConsiderLinespacingInTextHeight() {
        double height1OneLine;
        double height1TwoLine;
        String textOneLine;
        String texttwoLine = textOneLine = "OpenPatrician";
        int wrappingWidth = 500;
        int lineSpacing = 10;
        do {
            texttwoLine = texttwoLine + " " + textOneLine;
            height1OneLine = this.sizing.computeTextHeight(this.font18, textOneLine, (double)wrappingWidth, (double)lineSpacing);
        } while ((height1TwoLine = this.sizing.computeTextHeight(this.font18, texttwoLine, (double)wrappingWidth, (double)lineSpacing)) == height1OneLine);
        MatcherAssert.assertThat((Object)height1TwoLine, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(height1OneLine)));
        Assert.assertEquals((double)(height1OneLine * 2.0 + (double)lineSpacing), (double)height1TwoLine, (double)2.0);
    }

    @Test
    public void biggerFontsShouldHaveGreaterWidth() {
        String text = "OpenPatrician";
        int wrappingWidth = 1000;
        double width18 = this.sizing.computeTextWidth(this.font18, text, (double)wrappingWidth);
        double width24 = this.sizing.computeTextWidth(this.font24, text, (double)wrappingWidth);
        MatcherAssert.assertThat((Object)width24, (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(width18)));
    }

    @Test
    public void longerTextShouldHaveGreaterWidth() {
        String textOneLine = "OpenPatrician";
        String texttwoLine = "OpenPatrician OpenPatrician OpenPatrician OpenPatrician";
        int wrappingWidth = 1000;
        double widthShort = this.sizing.computeTextWidth(this.font18, textOneLine, (double)wrappingWidth);
        double widthLong = this.sizing.computeTextWidth(this.font18, texttwoLine, (double)wrappingWidth);
        MatcherAssert.assertThat((Object)widthLong, (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(widthShort)));
    }

    @Test
    public void wrappedTextShouldHaveGreaterWidthThanOneLine() {
        String textOneLine = "OpenPatrician";
        String texttwoLine = "OpenPatrician OpenPatrician OpenPatrician OpenPatrician";
        int wrappingWidth = 500;
        double widthShort = this.sizing.computeTextWidth(this.font18, textOneLine, (double)wrappingWidth);
        double widthLong = this.sizing.computeTextWidth(this.font18, texttwoLine, (double)wrappingWidth);
        MatcherAssert.assertThat((Object)widthLong, (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(widthShort)));
    }

    @Test
    public void shouldCalculateTwoLineText() {
        String textOneLine = "OpenPatrician";
        String texttwoLine = "OpenPatrician OpenPatrician OpenPatrician OpenPatrician";
        int wrappingWidth = 500;
        double heigthOneLine = this.sizing.computeTextHeight(this.font18, textOneLine, Double.MAX_VALUE);
        double widthOneLine = this.sizing.computeTextWidth(this.font18, textOneLine, Double.MAX_VALUE);
        Dimension2D dim = this.sizing.calculate(texttwoLine, this.font18);
        MatcherAssert.assertThat((Object)dim.getWidth(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(widthOneLine)));
        MatcherAssert.assertThat((Object)dim.getHeight(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(1.2 * heigthOneLine)));
        MatcherAssert.assertThat((Object)dim.getHeight(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(2.0 * heigthOneLine)));
    }

    @Test
    public void shouldAproximageTheRealDimensions() {
        String textOneLine = "OpenPatrician";
        double heigthOneLine = this.sizing.computeTextHeight(this.font18, textOneLine, Double.MAX_VALUE);
        double widthOneLine = this.sizing.computeTextWidth(this.font18, textOneLine, Double.MAX_VALUE);
        Dimension2D dim = this.sizing.calculate(textOneLine.length(), this.font18);
        MatcherAssert.assertThat((Object)dim.getHeight(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(1.0 * heigthOneLine)));
        MatcherAssert.assertThat((Object)dim.getHeight(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(1.5 * heigthOneLine)));
        MatcherAssert.assertThat((Object)dim.getWidth(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.8 * widthOneLine)));
        MatcherAssert.assertThat((Object)dim.getWidth(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(1.5 * widthOneLine)));
    }

    @Test
    public void shouldGuessNumberOfCharacterWithAccuracyPlusMinusOne() {
        String textOneLine = "OpenPatrician";
        double widthShort = this.sizing.computeTextWidth(this.font18, textOneLine, Double.MAX_VALUE);
        int nbCharacters = this.sizing.guessNumberOfCharacters(widthShort, this.font18);
        MatcherAssert.assertThat((Object)nbCharacters, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(textOneLine.length() - 1)));
        MatcherAssert.assertThat((Object)nbCharacters, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(textOneLine.length() + 1)));
    }
}

