/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.dialog;

import ch.sahits.game.openpatrician.javafx.dialog.Dialog;
import ch.sahits.game.openpatrician.testutilities.JavaFXThreadingRule;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DialogTest {
    @Rule
    public JavaFXThreadingRule javafxRule = new JavaFXThreadingRule();
    private Dialog dialog;

    @Test
    public void shouldOnlyHaveTwoChildren() {
        this.dialog = new Dialog();
        Assert.assertEquals((long)2L, (long)this.dialog.getChildren().size());
    }

    @Test
    public void firstChildShouldBeImageView() {
        this.dialog = new Dialog();
        Assert.assertThat((Object)this.dialog.getChildren().get(0), (Matcher)Matchers.instanceOf(ImageView.class));
    }

    @Test
    public void secondArgumentShouldBeTheGroupContainingContent() {
        this.dialog = new Dialog();
        Assert.assertThat((Object)this.dialog.getChildren().get(1), (Matcher)Matchers.instanceOf(Group.class));
        Group g = (Group)this.dialog.getChildren().get(1);
        Assert.assertEquals((Object)this.dialog.getContent(), (Object)g.getChildren());
    }

    @Test
    public void shouldReplaceContentChildren() {
        this.dialog = new Dialog();
        Label lbl1 = new Label();
        Label lbl2 = new Label();
        Label lbl3 = new Label();
        this.dialog.getContent().add((Object)lbl1);
        Assert.assertTrue((boolean)this.dialog.getContent().contains((Object)lbl1));
        this.dialog.replaceContent(new Node[]{lbl2, lbl3});
        Assert.assertEquals((long)2L, (long)this.dialog.getContent().size());
        Assert.assertFalse((boolean)this.dialog.getContent().contains((Object)lbl1));
        Assert.assertTrue((boolean)this.dialog.getContent().contains((Object)lbl2));
        Assert.assertTrue((boolean)this.dialog.getContent().contains((Object)lbl3));
    }
}

