/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardChurchMenuProvider;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@RunWith(value=MockitoJUnitRunner.class)
public class NoticeBoardChurchMenuProviderTest {
    @Mock
    private ch.sahits.game.openpatrician.utilities.l10n.Locale locale;
    @Mock
    private MessageSource messageSource;
    @Mock
    private ApplicationContext context;
    @Mock
    private DecoratedTextFactory textFactory;
    @InjectMocks
    private NoticeBoardChurchMenuProvider menuProvider;

    @Test
    public void shouldProvideFourMenuItems() {
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (Locale)Matchers.any(Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        LinkedHashSet entries = this.menuProvider.createMenuEntries((ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class), null);
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)4))).getMessage(Matchers.anyString(), (Object[])Matchers.any(), (Locale)Matchers.any(Locale.class));
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory, (VerificationMode)Mockito.times((int)4))).createSimpleDecoratedText(Matchers.anyString());
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CHURCH_PRAY});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CHURCH_FEED});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CHURCH_EXTENSION});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.CHURCH_GIFT});
        Assert.assertEquals((long)4L, (long)entries.size());
    }
}

