/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardGuildMenuProvider;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@RunWith(value=MockitoJUnitRunner.class)
public class NoticeBoardGuildMenuProviderTest {
    @Mock
    private ch.sahits.game.openpatrician.utilities.l10n.Locale locale;
    @Mock
    private MessageSource messageSource;
    @Mock
    private GuildList guildList;
    @Mock
    private ApplicationContext context;
    @Mock
    private DecoratedTextFactory textFactory;
    @Mock
    private IHumanPlayer player;
    @Mock
    private ICity city;
    @Mock
    private ICityPlayerProxyJFX proxy;
    @InjectMocks
    private NoticeBoardGuildMenuProvider provider;

    @Before
    public void setup() {
        BDDMockito.given((Object)this.proxy.getCity()).willReturn((Object)this.city);
        BDDMockito.given((Object)this.proxy.getPlayer()).willReturn((Object)this.player);
        DecoratedText text = new DecoratedText();
        text.append("some translation");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean((String)Matchers.eq((Object)"viewChangeActionRunnable"), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
    }

    @Test
    public void shouldCreateNoMenuEntryWhenNoGuild() {
        BDDMockito.given((Object)this.guildList.findGuild(this.city)).willReturn(Optional.empty());
        LinkedHashSet entries = this.provider.createMenuEntries(this.proxy, ENoticeBoardType.GUILD);
        Assert.assertTrue((boolean)entries.isEmpty());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.messageSource});
    }

    @Test
    public void shouldCreateMenuEntryWhenNotJoined() {
        IGuild guild = (IGuild)Mockito.mock(IGuild.class);
        BDDMockito.given((Object)this.guildList.findGuild(this.city)).willReturn(Optional.of(guild));
        BDDMockito.given((Object)guild.getMembers()).willReturn(Arrays.asList(new IPlayer[0]));
        LinkedHashSet entries = this.provider.createMenuEntries(this.proxy, ENoticeBoardType.GUILD);
        Assert.assertEquals((long)1L, (long)entries.size());
        ((MessageSource)Mockito.verify((Object)this.messageSource)).getMessage(Matchers.anyString(), (Object[])Matchers.any(), (Locale)Matchers.any(Locale.class));
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.GUILD_JOIN});
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory)).createSimpleDecoratedText(Matchers.anyString());
    }

    @Test
    public void shouldCreateMenuEntryWhenJoined() {
        IGuild guild = (IGuild)Mockito.mock(IGuild.class);
        BDDMockito.given((Object)this.guildList.findGuild(this.city)).willReturn(Optional.of(guild));
        BDDMockito.given((Object)guild.getMembers()).willReturn(Arrays.asList(this.player));
        LinkedHashSet entries = this.provider.createMenuEntries(this.proxy, ENoticeBoardType.GUILD);
        Assert.assertEquals((long)4L, (long)entries.size());
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)4))).getMessage(Matchers.anyString(), (Object[])Matchers.any(), (Locale)Matchers.any(Locale.class));
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.GUILD_MEMBERS});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.GUILD_AUCTION});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.GUILD_MEDITERREAN});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("viewChangeActionRunnable", new Object[]{EDialogType.GUILD_TRADE_AGREEMENT});
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory, (VerificationMode)Mockito.times((int)4))).createSimpleDecoratedText(Matchers.anyString());
    }
}

