/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenu;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardArmoryMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardChurchMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardCityHallMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardGuildMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardLoanerMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardMarketPlaceMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardMenuTitleProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardMessageMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardShipSelectionMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardShipyardMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardTavernMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardTradingMenuProvider;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardTradingOfficeMenuProvider;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.testutilities.JavaFXThreadingRule;
import java.util.LinkedHashSet;
import javafx.scene.control.Label;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NoticeBoardMenuProviderTest {
    @Rule
    public JavaFXThreadingRule jfxRule = new JavaFXThreadingRule();
    @Mock
    private NoticeBoardMenuTitleProvider titleProvider;
    @Mock
    private NoticeBoardMessageMenuProvider messageProvider;
    @Mock
    private NoticeBoardChurchMenuProvider churchMenuProvider;
    @Mock
    private NoticeBoardCityHallMenuProvider cityHallMenuProvider;
    @Mock
    private NoticeBoardMarketPlaceMenuProvider marketPlaceMenuProvider;
    @Mock
    private NoticeBoardTradingOfficeMenuProvider tradingOfficeMenuProvider;
    @Mock
    private NoticeBoardTradingMenuProvider tradingMenuProvider;
    @Mock
    private NoticeBoardTavernMenuProvider tavernMenuProvider;
    @Mock
    private NoticeBoardLoanerMenuProvider loanerMenuProvider;
    @Mock
    private NoticeBoardShipSelectionMenuProvider shipSelectionMenuProvider;
    @Mock
    private NoticeBoardShipyardMenuProvider shipyardMenuProvider;
    @Mock
    private NoticeBoardGuildMenuProvider guildMenuProvider;
    @Mock
    private NoticeBoardArmoryMenuProvider armoryMenuProvider;
    @Mock
    private ICity city;
    @InjectMocks
    private NoticeBoardMenuProvider menuProvider;
    @Mock
    private ICityPlayerProxyJFX proxy;

    @Before
    public void setup() {
        BDDMockito.given((Object)this.proxy.getCity()).willReturn((Object)this.city);
        BDDMockito.given((Object)this.titleProvider.createTitle((ENoticeBoardType)Matchers.any(ENoticeBoardType.class), (ICity)Matchers.eq((Object)this.city))).willReturn((Object)new Label());
        LinkedHashSet entries = new LinkedHashSet();
        BDDMockito.given((Object)this.messageProvider.createMenuEntries((ICityPlayerProxyJFX)Matchers.any(ICityPlayerProxyJFX.class), (ENoticeBoardType)Matchers.any())).willReturn(entries);
        BDDMockito.given((Object)this.churchMenuProvider.createMenuEntries((ICityPlayerProxyJFX)Matchers.any(ICityPlayerProxyJFX.class), (ENoticeBoardType)Matchers.any())).willReturn(entries);
        BDDMockito.given((Object)this.cityHallMenuProvider.createMenuEntries((ICityPlayerProxyJFX)Matchers.any(ICityPlayerProxyJFX.class), (ENoticeBoardType)Matchers.any())).willReturn(entries);
        BDDMockito.given((Object)this.marketPlaceMenuProvider.createMenuEntries((ICityPlayerProxyJFX)Matchers.any(ICityPlayerProxyJFX.class), (ENoticeBoardType)Matchers.any())).willReturn(entries);
        BDDMockito.given((Object)this.tradingOfficeMenuProvider.createMenuEntries((ICityPlayerProxyJFX)Matchers.any(ICityPlayerProxyJFX.class), (ENoticeBoardType)Matchers.any())).willReturn(entries);
        BDDMockito.given((Object)this.tradingMenuProvider.createMenuEntries((ICityPlayerProxyJFX)Matchers.any(ICityPlayerProxyJFX.class), (ENoticeBoardType)Matchers.any())).willReturn(entries);
        BDDMockito.given((Object)this.tavernMenuProvider.createMenuEntries((ICityPlayerProxyJFX)Matchers.any(ICityPlayerProxyJFX.class), (ENoticeBoardType)Matchers.any())).willReturn(entries);
        BDDMockito.given((Object)this.loanerMenuProvider.createMenuEntries((ICityPlayerProxyJFX)Matchers.any(ICityPlayerProxyJFX.class), (ENoticeBoardType)Matchers.any())).willReturn(entries);
        BDDMockito.given((Object)this.shipSelectionMenuProvider.createMenuEntries((ICityPlayerProxyJFX)Matchers.any(ICityPlayerProxyJFX.class), (ENoticeBoardType)Matchers.any())).willReturn(entries);
        BDDMockito.given((Object)this.shipyardMenuProvider.createMenuEntries((ICityPlayerProxyJFX)Matchers.any(ICityPlayerProxyJFX.class), (ENoticeBoardType)Matchers.any())).willReturn(entries);
        BDDMockito.given((Object)this.guildMenuProvider.createMenuEntries((ICityPlayerProxyJFX)Matchers.any(ICityPlayerProxyJFX.class), (ENoticeBoardType)Matchers.any())).willReturn(entries);
        BDDMockito.given((Object)this.armoryMenuProvider.createMenuEntries((ICityPlayerProxyJFX)Matchers.any(ICityPlayerProxyJFX.class), (ENoticeBoardType)Matchers.eq((Object)ENoticeBoardType.ARMORY))).willReturn(entries);
    }

    @Test
    public void shouldCallProviderForAllTypes() {
        for (ENoticeBoardType type : ENoticeBoardType.values()) {
            NoticeBoardMenu menu = this.menuProvider.createMenu(type, this.proxy);
            Assert.assertNotNull((Object)menu);
            Assert.assertNotNull((Object)menu.getMenuEntries());
        }
    }

    @Test
    public void shouldCallMessageProvider() {
        ENoticeBoardType type = ENoticeBoardType.MESSAGE;
        this.menuProvider.createMenu(type, this.proxy);
        ((NoticeBoardMenuTitleProvider)Mockito.verify((Object)this.titleProvider)).createTitle(type, this.city);
        ((NoticeBoardMessageMenuProvider)Mockito.verify((Object)this.messageProvider)).createMenuEntries(this.proxy, type);
        ((ICityPlayerProxyJFX)Mockito.verify((Object)this.proxy)).getCity();
        this.verifyNoMoreMockInteractions();
    }

    @Test
    public void shouldCallChurchProvider() {
        ENoticeBoardType type = ENoticeBoardType.CHURCH;
        this.menuProvider.createMenu(type, this.proxy);
        ((NoticeBoardMenuTitleProvider)Mockito.verify((Object)this.titleProvider)).createTitle(type, this.city);
        ((NoticeBoardChurchMenuProvider)Mockito.verify((Object)this.churchMenuProvider)).createMenuEntries(this.proxy, type);
        ((ICityPlayerProxyJFX)Mockito.verify((Object)this.proxy)).getCity();
        this.verifyNoMoreMockInteractions();
    }

    @Test
    public void shouldCallCityHallProvider() {
        ENoticeBoardType type = ENoticeBoardType.CITY_HALL_MAYORS_OFFICE;
        this.menuProvider.createMenu(type, this.proxy);
        ((NoticeBoardMenuTitleProvider)Mockito.verify((Object)this.titleProvider)).createTitle(type, this.city);
        ((NoticeBoardCityHallMenuProvider)Mockito.verify((Object)this.cityHallMenuProvider)).createMenuEntries(this.proxy, type);
        ((ICityPlayerProxyJFX)Mockito.verify((Object)this.proxy)).getCity();
        this.verifyNoMoreMockInteractions();
    }

    @Test
    public void shouldCallGuildProvider() {
        ENoticeBoardType type = ENoticeBoardType.GUILD;
        this.menuProvider.createMenu(type, this.proxy);
        ((NoticeBoardMenuTitleProvider)Mockito.verify((Object)this.titleProvider)).createTitle(type, this.city);
        ((NoticeBoardGuildMenuProvider)Mockito.verify((Object)this.guildMenuProvider)).createMenuEntries(this.proxy, type);
        ((ICityPlayerProxyJFX)Mockito.verify((Object)this.proxy)).getCity();
        this.verifyNoMoreMockInteractions();
    }

    private void verifyNoMoreMockInteractions() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.titleProvider, this.messageProvider, this.churchMenuProvider, this.cityHallMenuProvider, this.marketPlaceMenuProvider, this.tradingMenuProvider, this.tradingOfficeMenuProvider, this.tavernMenuProvider, this.loanerMenuProvider, this.shipSelectionMenuProvider, this.shipyardMenuProvider, this.guildMenuProvider, this.proxy});
    }

    @Test
    public void shouldCallMarketPlaceProvider() {
        ENoticeBoardType type = ENoticeBoardType.MARKET_PLACE;
        this.menuProvider.createMenu(type, this.proxy);
        ((NoticeBoardMenuTitleProvider)Mockito.verify((Object)this.titleProvider)).createTitle(type, this.city);
        ((NoticeBoardMarketPlaceMenuProvider)Mockito.verify((Object)this.marketPlaceMenuProvider)).createMenuEntries(this.proxy, type);
        ((ICityPlayerProxyJFX)Mockito.verify((Object)this.proxy)).getCity();
        this.verifyNoMoreMockInteractions();
    }

    @Test
    public void shouldCallTradingProvider() {
        ENoticeBoardType type = ENoticeBoardType.TRADING;
        this.menuProvider.createMenu(type, this.proxy);
        ((NoticeBoardMenuTitleProvider)Mockito.verify((Object)this.titleProvider)).createTitle(type, this.city);
        ((NoticeBoardTradingMenuProvider)Mockito.verify((Object)this.tradingMenuProvider)).createMenuEntries(this.proxy, type);
        ((ICityPlayerProxyJFX)Mockito.verify((Object)this.proxy)).getCity();
        this.verifyNoMoreMockInteractions();
    }

    @Test
    public void shouldCallTradingOfficeProvider() {
        ENoticeBoardType type = ENoticeBoardType.TRADING_OFFICE;
        this.menuProvider.createMenu(type, this.proxy);
        ((NoticeBoardMenuTitleProvider)Mockito.verify((Object)this.titleProvider)).createTitle(type, this.city);
        ((NoticeBoardTradingOfficeMenuProvider)Mockito.verify((Object)this.tradingOfficeMenuProvider)).createMenuEntries(this.proxy, type);
        ((ICityPlayerProxyJFX)Mockito.verify((Object)this.proxy)).getCity();
        this.verifyNoMoreMockInteractions();
    }

    @Test
    public void shouldCallTavernProvider() {
        ENoticeBoardType type = ENoticeBoardType.TAVERN;
        this.menuProvider.createMenu(type, this.proxy);
        ((NoticeBoardMenuTitleProvider)Mockito.verify((Object)this.titleProvider)).createTitle(type, this.city);
        ((NoticeBoardTavernMenuProvider)Mockito.verify((Object)this.tavernMenuProvider)).createMenuEntries(this.proxy, type);
        ((ICityPlayerProxyJFX)Mockito.verify((Object)this.proxy)).getCity();
        this.verifyNoMoreMockInteractions();
    }

    @Test
    public void shouldCallLoanerProvider() {
        ENoticeBoardType type = ENoticeBoardType.LOANER;
        this.menuProvider.createMenu(type, this.proxy);
        ((NoticeBoardMenuTitleProvider)Mockito.verify((Object)this.titleProvider)).createTitle(type, this.city);
        ((NoticeBoardLoanerMenuProvider)Mockito.verify((Object)this.loanerMenuProvider)).createMenuEntries(this.proxy, type);
        ((ICityPlayerProxyJFX)Mockito.verify((Object)this.proxy)).getCity();
        this.verifyNoMoreMockInteractions();
    }

    @Test
    public void shouldCallShipSelectionProvider() {
        ENoticeBoardType type = ENoticeBoardType.SHIP_SELECTION;
        this.menuProvider.createMenu(type, this.proxy);
        ((NoticeBoardMenuTitleProvider)Mockito.verify((Object)this.titleProvider)).createTitle(type, this.city);
        ((NoticeBoardShipSelectionMenuProvider)Mockito.verify((Object)this.shipSelectionMenuProvider)).createMenuEntries(this.proxy, type);
        ((ICityPlayerProxyJFX)Mockito.verify((Object)this.proxy)).getCity();
        this.verifyNoMoreMockInteractions();
    }

    @Test
    public void shouldCallShipyardProvider() {
        ENoticeBoardType type = ENoticeBoardType.SHIPYARD;
        this.menuProvider.createMenu(type, this.proxy);
        ((NoticeBoardMenuTitleProvider)Mockito.verify((Object)this.titleProvider)).createTitle(type, this.city);
        ((NoticeBoardShipyardMenuProvider)Mockito.verify((Object)this.shipyardMenuProvider)).createMenuEntries(this.proxy, type);
        ((ICityPlayerProxyJFX)Mockito.verify((Object)this.proxy)).getCity();
        this.verifyNoMoreMockInteractions();
    }

    @Test
    public void shouldCallArmoryProvider() {
        ENoticeBoardType type = ENoticeBoardType.ARMORY;
        this.menuProvider.createMenu(type, this.proxy);
        ((NoticeBoardMenuTitleProvider)Mockito.verify((Object)this.titleProvider)).createTitle(type, this.city);
        ((NoticeBoardArmoryMenuProvider)Mockito.verify((Object)this.armoryMenuProvider)).createMenuEntries(this.proxy, type);
        ((ICityPlayerProxyJFX)Mockito.verify((Object)this.proxy)).getCity();
        this.verifyNoMoreMockInteractions();
    }
}

