/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.NoticeBoardTavernMenuProvider;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.CitiesState;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ITavernPerson;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import javafx.collections.FXCollections;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@RunWith(value=MockitoJUnitRunner.class)
public class NoticeBoardTavernMenuProviderTest {
    @Mock
    private ch.sahits.game.openpatrician.utilities.l10n.Locale locale;
    @Mock
    private MessageSource messageSource;
    @Mock
    private DecoratedTextFactory textFactory;
    @Mock
    private ApplicationContext context;
    @Mock
    private CaptainsState captainsState;
    @Mock
    private CitiesState cityState;
    @InjectMocks
    private NoticeBoardTavernMenuProvider messageMenuProvider;

    @Test
    public void shouldAddPersonToMainRoomAndSideRoom() {
        TavernState tavernState = (TavernState)Mockito.mock(TavernState.class);
        ISideRoomPerson sideRoomPerson = (ISideRoomPerson)Mockito.mock(ISideRoomPerson.class);
        IInformant informant = (IInformant)Mockito.mock(IInformant.class);
        ArrayList<Object> present = new ArrayList<Object>();
        present.add(sideRoomPerson);
        present.add(informant);
        ArrayList sideroom = new ArrayList();
        ArrayList mainroom = new ArrayList();
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        this.messageMenuProvider.collectPresentPersons(tavernState, present, sideroom, mainroom, (IPlayer)player);
        Assert.assertTrue((boolean)sideroom.contains(sideRoomPerson));
        Assert.assertTrue((boolean)mainroom.contains(informant));
        Assert.assertEquals((long)1L, (long)sideroom.size());
        Assert.assertEquals((long)1L, (long)mainroom.size());
    }

    @Test
    public void shouldAddPersonToMainRoomAndSideRoomShouldNotAddWhenTalkingTo() {
        TavernState tavernState = (TavernState)Mockito.mock(TavernState.class);
        ISideRoomPerson sideRoomPerson = (ISideRoomPerson)Mockito.mock(ISideRoomPerson.class);
        IInformant informant = (IInformant)Mockito.mock(IInformant.class);
        ArrayList<Object> present = new ArrayList<Object>();
        present.add(sideRoomPerson);
        present.add(informant);
        ArrayList sideroom = new ArrayList();
        ArrayList mainroom = new ArrayList();
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        BDDMockito.given((Object)tavernState.isTalkingToOtherPlayer((ITavernPerson)sideRoomPerson, (IPlayer)player)).willReturn((Object)true);
        this.messageMenuProvider.collectPresentPersons(tavernState, present, sideroom, mainroom, (IPlayer)player);
        Assert.assertFalse((boolean)sideroom.contains(sideRoomPerson));
        Assert.assertTrue((boolean)mainroom.contains(informant));
        Assert.assertEquals((long)0L, (long)sideroom.size());
        Assert.assertEquals((long)1L, (long)mainroom.size());
    }

    @Test
    public void shouldIgnoreMapOwner1InSideRoomWhenPlayerDoesOwnMapSegment() {
        TavernState tavernState = (TavernState)Mockito.mock(TavernState.class);
        ISideRoomPerson sideRoomPerson = (ISideRoomPerson)Mockito.mock(ISideRoomPerson.class);
        ISideRoomPerson mapOwner = (ISideRoomPerson)Mockito.mock(ITreasureMapOwner.class);
        IInformant informant = (IInformant)Mockito.mock(IInformant.class);
        ArrayList<Object> present = new ArrayList<Object>();
        present.add(sideRoomPerson);
        present.add(mapOwner);
        present.add(informant);
        ArrayList sideroom = new ArrayList();
        ArrayList mainroom = new ArrayList();
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        BDDMockito.given((Object)player.getSegmentedMap()).willReturn(Mockito.mock(MapSegmentedImage.class));
        this.messageMenuProvider.collectPresentPersons(tavernState, present, sideroom, mainroom, (IPlayer)player);
        Assert.assertTrue((boolean)sideroom.contains(sideRoomPerson));
        Assert.assertTrue((boolean)mainroom.contains(informant));
        Assert.assertEquals((long)1L, (long)sideroom.size());
        Assert.assertEquals((long)1L, (long)mainroom.size());
    }

    @Test
    public void shouldIgnoreMapOwner2InSideRoomWhenPlayerDoesOwnMapSegment() {
        TavernState tavernState = (TavernState)Mockito.mock(TavernState.class);
        ISideRoomPerson sideRoomPerson = (ISideRoomPerson)Mockito.mock(ISideRoomPerson.class);
        ISideRoomPerson mapOwner = (ISideRoomPerson)Mockito.mock(IPirateHunter.class);
        IInformant informant = (IInformant)Mockito.mock(IInformant.class);
        ArrayList<Object> present = new ArrayList<Object>();
        present.add(sideRoomPerson);
        present.add(mapOwner);
        present.add(informant);
        ArrayList sideroom = new ArrayList();
        ArrayList mainroom = new ArrayList();
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        BDDMockito.given((Object)player.getSegmentedMap()).willReturn(Mockito.mock(MapSegmentedImage.class));
        this.messageMenuProvider.collectPresentPersons(tavernState, present, sideroom, mainroom, (IPlayer)player);
        Assert.assertTrue((boolean)sideroom.contains(sideRoomPerson));
        Assert.assertTrue((boolean)mainroom.contains(informant));
        Assert.assertEquals((long)1L, (long)sideroom.size());
        Assert.assertEquals((long)1L, (long)mainroom.size());
    }

    @Test
    public void shouldCreateMessageItems() {
        ICity city = (ICity)Mockito.mock(ICity.class);
        ICityPlayerProxyJFX proxy = (ICityPlayerProxyJFX)Mockito.mock(ICityPlayerProxyJFX.class);
        BDDMockito.given((Object)proxy.getCity()).willReturn((Object)city);
        TavernState tavernState = (TavernState)Mockito.mock(TavernState.class);
        ISideRoomPerson sideRoomPerson = (ISideRoomPerson)Mockito.mock(ISideRoomPerson.class);
        IInformant informant = (IInformant)Mockito.mock(IInformant.class);
        ArrayList<Object> present = new ArrayList<Object>();
        present.add(sideRoomPerson);
        present.add(informant);
        CityState cityState = (CityState)Mockito.mock(CityState.class);
        ArrayList<CityState> cityStates = new ArrayList<CityState>();
        cityStates.add(cityState);
        BDDMockito.given((Object)this.cityState.getCityEngineStates()).willReturn(cityStates);
        BDDMockito.given((Object)cityState.getCity()).willReturn((Object)city);
        BDDMockito.given((Object)cityState.getTavernState()).willReturn((Object)tavernState);
        IHumanPlayer player = (IHumanPlayer)Mockito.mock(IHumanPlayer.class);
        BDDMockito.given((Object)proxy.getPlayer()).willReturn((Object)player);
        ICaptain captain = (ICaptain)Mockito.mock(ICaptain.class);
        BDDMockito.given((Object)this.captainsState.getCaptain(city)).willReturn(Optional.of(captain));
        BDDMockito.given((Object)tavernState.presentPersonsProperty()).willReturn((Object)FXCollections.observableArrayList(present));
        BDDMockito.given((Object)this.locale.getCurrentLocal()).willReturn((Object)Locale.ENGLISH);
        BDDMockito.given((Object)this.messageSource.getMessage(Matchers.anyString(), (Object[])Matchers.any(), (Locale)Matchers.any(Locale.class))).willReturn((Object)"some translation");
        DecoratedText text = new DecoratedText();
        text.append("some trans...");
        BDDMockito.given((Object)this.textFactory.createSimpleDecoratedText(Matchers.anyString())).willReturn((Object)text);
        Runnable runnable = () -> {};
        BDDMockito.given((Object)this.context.getBean(Matchers.anyString(), (Object[])Matchers.any(Object[].class))).willReturn((Object)runnable);
        LinkedHashSet entries = this.messageMenuProvider.createMenuEntries(proxy, null);
        ((MessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)3))).getMessage(Matchers.anyString(), (Object[])Matchers.any(), (Locale)Matchers.any(Locale.class));
        ((DecoratedTextFactory)Mockito.verify((Object)this.textFactory, (VerificationMode)Mockito.times((int)3))).createSimpleDecoratedText(Matchers.anyString());
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("tavernDialogChangeAction", new Object[]{captain, tavernState, player, EDialogType.TAVERN_CAPTAIN});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("tavernDialogChangeAction", new Object[]{informant, tavernState, player, EDialogType.TAVERN_INFORMANT_1});
        ((ApplicationContext)Mockito.verify((Object)this.context)).getBean("tavernDialogTalkToSideroomPersonAction", new Object[]{sideRoomPerson, tavernState, player});
        Assert.assertEquals((long)3L, (long)entries.size());
    }
}

