/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.javafx.service.TextEllipsisCalculator;
import javafx.geometry.Dimension2D;
import javafx.scene.text.Font;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TextEllipsisCalculatorTest {
    @Mock
    private TextSizingUtility sizing;
    private Font font = Font.getDefault();
    @InjectMocks
    private TextEllipsisCalculator calculator;
    private final double maxWidth = 150.0;
    private final String ellipsis = "...";

    @Before
    public void setup() {
        BDDMockito.given((Object)this.sizing.calculate("...", this.font)).willReturn((Object)new Dimension2D(10.0, 18.0));
    }

    @Test
    public void shouldNotEllipseInitialShortEnough() {
        String text = "abcdefghijklm";
        BDDMockito.given((Object)this.sizing.guessNumberOfCharacters(140.0, this.font)).willReturn((Object)14);
        BDDMockito.given((Object)this.sizing.calculate(text, this.font)).willReturn((Object)new Dimension2D(145.0, 18.0));
        String result = this.calculator.calculateEllipsis(this.font, text, 150.0);
        Assert.assertEquals((Object)text, (Object)result);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).calculate("...", this.font);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).guessNumberOfCharacters(140.0, this.font);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).calculate(text, this.font);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.sizing});
    }

    @Test
    public void shouldNotEllipseInitialShortEnoughButGuessedLonger() {
        String text = "abcdefghijklmno";
        BDDMockito.given((Object)this.sizing.guessNumberOfCharacters(140.0, this.font)).willReturn((Object)14);
        BDDMockito.given((Object)this.sizing.calculate("abcdefghijklmn...", this.font)).willReturn((Object)new Dimension2D(149.0, 18.0));
        BDDMockito.given((Object)this.sizing.calculate(text, this.font)).willReturn((Object)new Dimension2D(145.0, 18.0));
        String result = this.calculator.calculateEllipsis(this.font, text, 150.0);
        Assert.assertEquals((Object)text, (Object)result);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).calculate("...", this.font);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).guessNumberOfCharacters(140.0, this.font);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).calculate("abcdefghijklmn...", this.font);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).calculate(text, this.font);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.sizing});
    }

    @Test
    public void shouldEllipseGuessedLengthLongerThanAllowed() {
        String text = "abcdefghijklmno";
        BDDMockito.given((Object)this.sizing.guessNumberOfCharacters(140.0, this.font)).willReturn((Object)14);
        BDDMockito.given((Object)this.sizing.calculate("abcdefghijklmn...", this.font)).willReturn((Object)new Dimension2D(159.0, 18.0));
        BDDMockito.given((Object)this.sizing.calculate("abcdefghijklm...", this.font)).willReturn((Object)new Dimension2D(149.0, 18.0));
        String result = this.calculator.calculateEllipsis(this.font, text, 150.0);
        Assert.assertEquals((Object)"abcdefghijklm...", (Object)result);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).calculate("...", this.font);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).guessNumberOfCharacters(140.0, this.font);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).calculate("abcdefghijklmn...", this.font);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).calculate("abcdefghijklm...", this.font);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.sizing});
    }

    @Test
    public void shouldEllipseGuessedLengthLongerThanAllowedIncreaseLength() {
        String text = "abcdefghijklmno";
        BDDMockito.given((Object)this.sizing.guessNumberOfCharacters(140.0, this.font)).willReturn((Object)13);
        BDDMockito.given((Object)this.sizing.calculate("abcdefghijklm...", this.font)).willReturn((Object)new Dimension2D(135.0, 18.0));
        BDDMockito.given((Object)this.sizing.calculate("abcdefghijklmn...", this.font)).willReturn((Object)new Dimension2D(149.0, 18.0));
        BDDMockito.given((Object)this.sizing.calculate(text, this.font)).willReturn((Object)new Dimension2D(155.0, 18.0));
        String result = this.calculator.calculateEllipsis(this.font, text, 150.0);
        Assert.assertEquals((Object)"abcdefghijklmn...", (Object)result);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).calculate("...", this.font);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).guessNumberOfCharacters(140.0, this.font);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).calculate("abcdefghijklm...", this.font);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).calculate("abcdefghijklmn...", this.font);
        ((TextSizingUtility)Mockito.verify((Object)this.sizing)).calculate(text, this.font);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.sizing});
    }
}

