/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.javafx.control.IWordSplitter;
import ch.sahits.game.openpatrician.javafx.control.Line;
import ch.sahits.game.openpatrician.javafx.control.Page;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.model.CenteredLine;
import ch.sahits.game.openpatrician.utilities.model.Heading;
import ch.sahits.game.openpatrician.utilities.model.ITextComponent;
import ch.sahits.game.openpatrician.utilities.model.Paragraph;
import ch.sahits.game.openpatrician.utilities.model.Text;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javafx.scene.text.Font;

@ClassCategory(value={EClassCategory.JAVAFX})
public class PageSplitter {
    public static final String CENTERED_STYLE = "pagination-centered";
    public static final String PARAGRAPH_STYLE = "pagination-paragraph";
    public static final String HEADING_STYLE = "pagination-heading";
    public static final String[] STYLES = new String[]{"pagination-heading", "pagination-paragraph", "pagination-centered"};
    private final double pageHeigth;
    private final double pageWidth;
    private final double lineSpacing;
    private final double initialHeigth;
    private final Font font;
    private TextSizingUtility sizing;
    private IWordSplitter splitter;

    public PageSplitter(double pageHeigth, double pageWidth, double lineSpacing, double initialHeigth, Font font) {
        this.pageHeigth = pageHeigth;
        this.pageWidth = pageWidth;
        this.lineSpacing = lineSpacing;
        this.initialHeigth = initialHeigth;
        this.font = font;
        this.sizing = new TextSizingUtility();
    }

    void overrideTextSizingUtility(TextSizingUtility sizing) {
        this.sizing = sizing;
    }

    public void setWordSplitter(IWordSplitter splitter) {
        this.splitter = splitter;
    }

    public List<Page> splitIntoPages(Text text) {
        return this.splitIntoPages(text, false);
    }

    private List<Page> splitIntoPages(Text text, boolean eliminateWhiteSpaces) {
        ArrayList<Page> pages = new ArrayList<Page>();
        List components = text.getText();
        StringBuilder oneLine = new StringBuilder();
        Page page = new Page();
        double currentPageHeight = this.initialHeigth;
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            String s;
            ITextComponent component = (ITextComponent)iterator.next();
            String textStyle = "";
            if (component instanceof Heading) {
                s = ((Heading)component).getHeader();
                textStyle = HEADING_STYLE;
            } else if (component instanceof Paragraph) {
                s = ((Paragraph)component).getParagraph();
                textStyle = PARAGRAPH_STYLE;
            } else if (component instanceof CenteredLine) {
                s = ((CenteredLine)component).getLine();
                textStyle = CENTERED_STYLE;
            } else {
                throw new IllegalStateException("Unhandled text component");
            }
            StringTokenizer tokenizer = new StringTokenizer(s);
            while (tokenizer.hasMoreTokens()) {
                String word = tokenizer.nextToken();
                if (oneLine.length() > 0) {
                    oneLine.append(" ");
                }
                oneLine.append(word);
                double lineWidth = this.sizing.computeTextWidth(this.font, oneLine.toString(), Double.MAX_VALUE);
                boolean lineAdded = false;
                if (this.isLineTooLong(lineWidth)) {
                    String line = oneLine.lastIndexOf(" ") > 0 ? oneLine.substring(0, oneLine.lastIndexOf(" ")) : oneLine.toString();
                    Line l = new Line();
                    if (eliminateWhiteSpaces) {
                        line = line.replaceAll(" ", "");
                    }
                    l.setLine(line);
                    l.setStyleClass(textStyle);
                    lineWidth = this.sizing.computeTextWidth(this.font, l.getLine(), Double.MAX_VALUE);
                    if (!this.isLineTooLong(lineWidth)) {
                        page.addLine(l);
                    }
                    if (this.isLineTooLong(lineWidth = this.sizing.computeTextWidth(this.font, word, Double.MAX_VALUE))) {
                        if (!tokenizer.hasMoreTokens()) {
                            page.addLine(l);
                        }
                        Object[] parts = this.splitter.split(word);
                        Text tmpText = new Text();
                        Paragraph p = new Paragraph(Joiner.on((char)' ').join(parts));
                        tmpText.addParagraph(p);
                        List<Page> tmpPages = this.splitIntoPages(tmpText, true);
                        if (tmpPages.size() > 1) {
                            throw new IllegalStateException("Got a more than on page out of a single word.");
                        }
                        List<Line> lines = tmpPages.get(0).getLines();
                        int index = 0;
                        while (index < lines.size()) {
                            l = lines.get(index++);
                            String compacted = l.getLine().replaceAll(" ", "");
                            l.setLine(compacted);
                            currentPageHeight = this.updatePageHeight(compacted, currentPageHeight);
                            if (currentPageHeight > this.pageHeigth) {
                                pages.add(page);
                                currentPageHeight = this.initialHeigth;
                                page = new Page();
                            }
                            l.setStyleClass(textStyle);
                            page.addLine(l);
                        }
                        oneLine = new StringBuilder();
                        lineAdded = true;
                    } else {
                        oneLine = new StringBuilder(word);
                        lineAdded = false;
                    }
                    currentPageHeight = this.updatePageHeight(line, currentPageHeight);
                }
                if (!tokenizer.hasMoreTokens() && !lineAdded) {
                    Line l = new Line();
                    String line = oneLine.toString();
                    if (eliminateWhiteSpaces) {
                        line = line.replaceAll(" ", "");
                    }
                    l.setLine(line);
                    l.setStyleClass(textStyle);
                    page.addLine(l);
                    currentPageHeight = this.updatePageHeight(oneLine.toString(), currentPageHeight);
                    oneLine = new StringBuilder();
                }
                if (!(currentPageHeight > this.pageHeigth)) continue;
                Line lastLine = page.removeLastLine();
                pages.add(page);
                currentPageHeight = this.initialHeigth;
                page = new Page();
                page.addLine(lastLine);
                currentPageHeight = this.updatePageHeight(lastLine.getLine(), currentPageHeight);
            }
            if (iterator.hasNext()) continue;
            pages.add(page);
        }
        return pages;
    }

    private boolean isLineTooLong(double lineWidth) {
        return lineWidth > this.pageWidth;
    }

    private double updatePageHeight(String line, double currentPageHeight) {
        double lineHeigth = this.sizing.computeTextHeight(this.font, line, Double.MAX_VALUE);
        return currentPageHeight += this.lineSpacing + lineHeigth;
    }
}

