/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.model;

import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class DisplayMessages {
    public static final int MESSAGE_STORE_SIZE = 50;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @ListType(value=DisplayMessage.class)
    private SimpleListProperty<DisplayMessage> messages = new SimpleListProperty();

    public DisplayMessages() {
        this.messages.set(FXCollections.observableArrayList());
    }

    @PostConstruct
    private void init() {
        this.clientEventBus.register((Object)this);
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
        this.clientServerEventBus.unregister((Object)this);
    }

    private boolean add(DisplayMessage element) {
        if (this.messages.size() == 50) {
            this.messages.remove(49);
        }
        this.messages.add(0, (Object)element);
        return true;
    }

    @Subscribe
    public void handleMessage(DisplayMessage message) {
        this.add(message);
    }

    public ObservableList<DisplayMessage> messagesProperty() {
        return this.messages;
    }
}

