/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.javafx.control.BaleAmount;
import ch.sahits.game.openpatrician.javafx.control.BarrelAmount;
import ch.sahits.game.openpatrician.javafx.control.CoinPrice;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.util.StringUtils;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class DecoratedTextFactory {
    public static final String COIN_ICON = "icon:Coin";
    public static final String BARREL_ICON = "icon:Barrel";
    public static final String BALE_ICON = "icon:Bale";
    public static final String GENERIC_ICON = "icon:Generic";
    public static final String SEGMENT_IMAGE = "image:Segment";
    public static final String IMAGE = "image";
    private final int leftInset;
    private final int topInset;
    private final int wrappingWidth;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;
    @Autowired
    private IFontLoader fontLoader;

    public DecoratedTextFactory(int leftInset, int topInset, int wrappingWidth) {
        this.leftInset = leftInset;
        this.topInset = topInset;
        this.wrappingWidth = wrappingWidth;
    }

    public VBox createMultiParagraphContainer() {
        VBox box = new VBox();
        box.setLayoutY((double)this.topInset);
        box.setLayoutX((double)this.leftInset);
        box.setMaxWidth((double)this.wrappingWidth);
        return box;
    }

    public DecoratedText createDecoratedText(String template, Map<String, Object> parameters) {
        DecoratedText text = new DecoratedText();
        return this.initializeDecoratedText(template, parameters, text);
    }

    public Label createLabel(String template) {
        Label text = new Label();
        text.getStylesheets().add((Object)DecoratedText.class.getResource(DecoratedText.class.getSimpleName() + ".css").toExternalForm());
        text.getStyleClass().add((Object)"decoratedText");
        text.setText(template);
        return text;
    }

    public DecoratedText createSimpleDecoratedText(String template) {
        DecoratedText text = new DecoratedText();
        text.setText(template);
        return text;
    }

    private DecoratedText initializeDecoratedText(String template, Map<String, Object> parameters, DecoratedText text) {
        text.getStylesheets().add((Object)DecoratedText.class.getResource(DecoratedText.class.getSimpleName() + ".css").toExternalForm());
        text.getStyleClass().add((Object)"decoratedText");
        text.setLayoutY(this.topInset);
        text.setLayoutX(this.leftInset);
        text.setWrappingWidth(this.wrappingWidth);
        String[] lines = template.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String curTemplate = lines[i];
            if (i == lines.length - 1 && template.endsWith("\n") || i < lines.length - 1) {
                curTemplate = curTemplate + "\n";
            }
            text = this.replaceParameters(text, curTemplate, parameters);
        }
        return text;
    }

    public DecoratedText createDecoratedText(String template, String styleClass, Map<String, Object> parameters) {
        DecoratedText text = new DecoratedText(styleClass);
        return this.initializeDecoratedText(template, parameters, text);
    }

    public String replaceTextParameters(String template, Map<String, Object> parameters) {
        int start = template.indexOf(91);
        int end = template.indexOf(93);
        if (start >= 0 && end > start) {
            String head = template.substring(0, start);
            String tail = template.substring(end + 1);
            if (tail.startsWith(" ")) {
                tail = tail.substring(1);
            }
            String key = template.substring(start + 1, end);
            Preconditions.checkNotNull(parameters, (Object)"Parameters object may not be null");
            Preconditions.checkArgument((boolean)parameters.containsKey(key), (Object)("Parameters object does not contain key: " + key));
            return this.replaceSimpleParameter(parameters, head, tail, key);
        }
        return template;
    }

    private DecoratedText replaceParameters(DecoratedText text, String template, Map<String, Object> parameters) {
        int start = template.indexOf(91);
        int end = template.indexOf(93);
        if (start >= 0 && end > start) {
            String head = template.substring(0, start);
            String tail = template.substring(end + 1);
            if (tail.startsWith(" ")) {
                tail = tail.substring(1);
            }
            String key = template.substring(start + 1, end);
            Preconditions.checkNotNull(parameters, (Object)"Parameters object may not be null");
            if (this.isSpecialKey(key)) {
                text.append(head);
                return this.replaceSpecialParameter(text, parameters, tail, key);
            }
            Preconditions.checkArgument((boolean)parameters.containsKey(key), (Object)("Parameters object does not contain key: " + key));
            return this.replaceSimpleParameter(text, parameters, head, tail, key);
        }
        text.append(template);
        return text;
    }

    private DecoratedText replaceSpecialParameter(DecoratedText text, Map<String, Object> parameters, String tail, String key) {
        Group specialNode1;
        String keyType;
        switch (keyType = key.substring(0, key.indexOf(" "))) {
            case "icon:Coin": {
                specialNode1 = new CoinPrice();
                String paramKey = key.substring(key.indexOf(" ") + 1);
                if (StringUtils.isInteger((String)paramKey)) {
                    specialNode1.setAmount(Integer.parseInt(paramKey));
                    break;
                }
                Preconditions.checkArgument((!parameters.containsKey(key) ? 1 : 0) != 0, (Object)("Parameters object does not contain key: " + key));
                ((CoinPrice)specialNode1).setAmount((int)((Integer)parameters.get(paramKey)));
                break;
            }
            case "icon:Barrel": {
                specialNode1 = new BarrelAmount();
                String paramKey = key.substring(key.indexOf(" ") + 1);
                if (StringUtils.isInteger((String)paramKey)) {
                    ((BarrelAmount)specialNode1).setAmount(Integer.parseInt(paramKey));
                    break;
                }
                Preconditions.checkArgument((!parameters.containsKey(key) ? 1 : 0) != 0, (Object)("Parameters object does not contain key: " + key));
                ((BarrelAmount)specialNode1).setAmount((int)((Integer)parameters.get(paramKey)));
                break;
            }
            case "icon:Bale": {
                specialNode1 = new BaleAmount();
                String paramKey = key.substring(key.indexOf(" ") + 1);
                if (StringUtils.isInteger((String)paramKey)) {
                    ((BaleAmount)specialNode1).setAmount(Integer.parseInt(paramKey));
                    break;
                }
                Preconditions.checkArgument((!parameters.containsKey(key) ? 1 : 0) != 0, (Object)("Parameters object does not contain key: " + key));
                ((BaleAmount)specialNode1).setAmount((int)((Integer)parameters.get(paramKey)));
                break;
            }
            case "image:Segment": {
                String[] params = key.split(" ");
                String imageName = params[1];
                String paramName = params[2];
                Preconditions.checkArgument((!parameters.containsKey(key) ? 1 : 0) != 0, (Object)("Parameters object does not contain key: " + key));
                specialNode1 = new StackPane();
                Rectangle ph = new Rectangle((double)this.wrappingWidth, 1.0, (Paint)Color.TRANSPARENT);
                Image img = this.imageLoader.getImage(imageName);
                ImageView imgView = new ImageView(img);
                Shape clip = this.createSegmentedShape(img.getWidth(), img.getHeight(), (List)parameters.get(paramName));
                imgView.setClip((Node)clip);
                ((StackPane)specialNode1).getChildren().addAll((Object[])new Node[]{ph, imgView});
                break;
            }
            case "image": {
                String[] params = key.split(" ");
                String imageName = params[1];
                specialNode1 = new StackPane();
                Rectangle ph = new Rectangle((double)this.wrappingWidth, 1.0, (Paint)Color.TRANSPARENT);
                Image img = this.imageLoader.getImage(imageName);
                ImageView imgView = new ImageView(img);
                ((StackPane)specialNode1).getChildren().addAll((Object[])new Node[]{ph, imgView});
                break;
            }
            case "icon:Generic": {
                String imageKey;
                String paramKey = key.substring(key.indexOf(" ") + 1);
                double size = this.fontLoader.createDefaultFont(18).getSize();
                int repeat = 1;
                if (paramKey.contains(" ")) {
                    imageKey = paramKey.substring(0, paramKey.indexOf(" "));
                    repeat = Integer.parseInt(paramKey.substring(paramKey.indexOf(" ") + 1));
                } else {
                    imageKey = paramKey;
                }
                Image iconOrig = this.imageLoader.getImage(imageKey);
                double scaleFactor = size / iconOrig.getHeight();
                Image img = this.imageLoader.getImage(imageKey, size, iconOrig.getWidth() * scaleFactor);
                ImageView imgView = new ImageView(img);
                if (repeat < 2) {
                    specialNode1 = new Group(new Node[]{imgView});
                    break;
                }
                HBox flowPane = new HBox();
                flowPane.getChildren().add((Object)imgView);
                for (int i = 1; i < repeat; ++i) {
                    imgView = new ImageView(img);
                    flowPane.getChildren().add((Object)imgView);
                }
                specialNode1 = new Group(new Node[]{flowPane});
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown key" + keyType);
            }
        }
        Group specialNode = specialNode1;
        text.append((Node)specialNode);
        return this.replaceParameters(text, tail, parameters);
    }

    private Shape createSegmentedShape(double width, double heigth, List<Integer> visibleSegments) {
        double segmentWidth = width / 3.0;
        double segmentHeight = heigth / 3.0;
        Rectangle shape = new Rectangle();
        for (Integer visibleSegment : visibleSegments) {
            Rectangle rect = new Rectangle();
            rect.setWidth(segmentWidth);
            rect.setHeight(segmentHeight);
            int row = (visibleSegment - 1) / 3;
            int col = (visibleSegment - 1) % 3;
            rect.setY((double)row * segmentHeight);
            rect.setX((double)col * segmentWidth);
            shape = Shape.union((Shape)shape, (Shape)rect);
        }
        return shape;
    }

    private boolean isSpecialKey(String key) {
        if (key.startsWith(COIN_ICON)) {
            return true;
        }
        if (key.startsWith(BARREL_ICON)) {
            return true;
        }
        if (key.startsWith(BALE_ICON)) {
            return true;
        }
        if (key.startsWith(SEGMENT_IMAGE)) {
            return true;
        }
        if (key.startsWith(IMAGE)) {
            return true;
        }
        return key.startsWith(GENERIC_ICON);
    }

    private DecoratedText replaceSimpleParameter(DecoratedText text, Map<String, Object> parameters, String head, String tail, String key) {
        if (tail.startsWith("\n")) {
            text.append(head + parameters.get(key) + "\n");
            tail = tail.substring(1);
            if (tail.length() > 0) {
                return this.replaceParameters(text, tail, parameters);
            }
            return text;
        }
        text.append(head + parameters.get(key));
        if (tail.length() > 0) {
            return this.replaceParameters(text, tail, parameters);
        }
        return text;
    }

    private String replaceSimpleParameter(Map<String, Object> parameters, String head, String tail, String key) {
        StringBuffer text = new StringBuffer();
        if (tail.startsWith("\n")) {
            text.append(head + parameters.get(key) + "\n");
            tail = tail.substring(1);
            if (tail.length() > 0) {
                text.append(tail);
                return this.replaceTextParameters(text.toString(), parameters);
            }
            return text.toString();
        }
        text.append(head + parameters.get(key) + " ");
        if (tail.length() > 0) {
            text.append(tail);
            return this.replaceTextParameters(text.toString(), parameters);
        }
        return text.toString();
    }
}

