/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.javafx.service;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.model.ENoticeBoardType;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.INoticeBoardMenuProvider;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javafx.collections.ObservableList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class NoticeBoardShipSelectionMenuProvider
implements INoticeBoardMenuProvider {
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ShipService shipService;
    @Autowired
    protected DecoratedTextFactory textFactory;

    @Override
    public LinkedHashSet<NoticeBoardMenuEntry> createMenuEntries(ICityPlayerProxyJFX proxy, ENoticeBoardType type) {
        LinkedHashSet<NoticeBoardMenuEntry> entries = new LinkedHashSet<NoticeBoardMenuEntry>();
        ObservableList vessels = proxy.getPlayersNavalVessels();
        for (INavigableVessel vessel : vessels) {
            NoticeBoardMenuEntry entry;
            String key;
            boolean disabled;
            int weaponsStrength = this.shipService.calculateShipsWeaponsStrength(vessel);
            if (vessel instanceof IShip) {
                boolean disabled2 = false;
                String key2 = "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.ship";
                NoticeBoardMenuEntry entry2 = this.createNoticeBoardEntry(proxy, vessel, disabled2, "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.ship", false, 200);
                entries.add(entry2);
                continue;
            }
            IConvoy convoy = (IConvoy)vessel;
            boolean bl = disabled = !convoy.getOwner().equals(proxy.getPlayer());
            if (weaponsStrength < 5) {
                key = "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.convoy.captain.smallstrangth.capacity";
                entry = this.createNoticeBoardEntry(proxy, (INavigableVessel)convoy, disabled, "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.convoy.captain.smallstrangth.capacity", false, 160);
                entries.add(entry);
            } else {
                key = "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.convoy.captain.bigstrangth.capacity";
                entry = this.createNoticeBoardEntry(proxy, (INavigableVessel)convoy, disabled, "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.convoy.captain.bigstrangth.capacity", false, 160);
                entries.add(entry);
            }
            List convoyMembers = convoy.getShips();
            for (IShip convoyMember : convoyMembers) {
                disabled = !convoyMember.getOwner().equals(proxy.getPlayer());
                String key3 = "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.shipinconvoy";
                NoticeBoardMenuEntry entry3 = this.createNoticeBoardEntry(proxy, (INavigableVessel)convoyMember, disabled, "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.shipinconvoy", true, 180);
                entries.add(entry3);
            }
        }
        return entries;
    }

    private NoticeBoardMenuEntry createNoticeBoardEntry(ICityPlayerProxyJFX proxy, INavigableVessel vessel, boolean disabled, String key, boolean inset, int wrappingWidth) {
        String loadedText = this.messageSource.getMessage(key, new Object[]{vessel.getName(), vessel.getCapacity()}, this.locale.getCurrentLocal());
        return this.createMenuEntry(proxy, vessel, loadedText, disabled, wrappingWidth);
    }

    private NoticeBoardMenuEntry createMenuEntry(ICityPlayerProxyJFX proxy, INavigableVessel vessel, String loadedText, boolean disabled, int wrappingWidth) {
        DecoratedText dt = this.textFactory.createDecoratedText(loadedText, new HashMap<String, Object>());
        dt.setWrappingWidth(210);
        NoticeBoardMenuEntry entry = new NoticeBoardMenuEntry(null);
        entry.setLabel(dt);
        entry.setDisabled(disabled);
        entry.setSelected(vessel.equals(proxy.getActiveShip()));
        return entry;
    }
}

