package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.javafx.bindings.StringToIntegerBinding;
import ch.sahits.game.openpatrician.javafx.bindings.ZeroAmountBooleanBinding;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

@ClassCategory(EClassCategory.JAVAFX)
public class BaleAmount extends BaleAmountAlwaysVisible{
      public BaleAmount() {
          super();
          IntegerProperty intAmount = new SimpleIntegerProperty();
          intAmount.bind(new StringToIntegerBinding(amountProperty()));
          visibleProperty().bind(new ZeroAmountBooleanBinding(intAmount));

      }
}
