package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import javafx.geometry.Dimension2D;
import javafx.scene.image.Image;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
/**
 * Utility class for image manipulation.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 23, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class ImageFactory {
	@MapType(key=Float.class, value=String.class)
	private static LinkedHashMap<Float, String> slabMap = new LinkedHashMap<>();
	@MapType(key=Float.class, value=String.class)
	private static LinkedHashMap<Float, String> slabExtMap = new LinkedHashMap<>();
	static {
		slabMap.put(1.3f, "StoneSlab_1_3.png");
		slabMap.put(2.2f, "StoneSlab_2_2.png");
		slabMap.put(3.5f, "StoneSlab_3_5.png");
		slabMap.put(4.1f, "StoneSlab_4_1.png");
		slabMap.put(4.7f, "StoneSlab_4_7.png");
		slabMap.put(5.8f, "StoneSlab_5_8.png");
		slabExtMap.put(1.1f, "StoneSlabExt_1_1.png");
		slabExtMap.put(2.2f, "StoneSlabExt_2_2.png");
		slabExtMap.put(2.7f, "StoneSlabExt_2_7.png");
		slabExtMap.put(3.0f, "StoneSlabExt_3_0.png");
		slabExtMap.put(3.1f, "StoneSlabExt_3_1.png");
		slabExtMap.put(3.6f, "StoneSlabExt_3_6.png");
	}
	  /**
	   * Compute the filename based on the stretching factor
	   * @param width of the button
	   * @param height of the button
	   * @return
	   */
	  private String getFileName(int width, int height) {
		  float f = width*1f/height;
		  String minDistFileName="StoneSlabBorderless.png";
		  return getFileName(f, minDistFileName,slabMap);
	  }
	/**
	 * Retrieve the file name that matches best the proportions to be displayed
	 * @param f result of the division of the displayable width through the displayable height
	 * @param defaultFileName default file name to be used
	 * @param fNames Hashmap to be used with the file names
	 * @return file name
	 */
	private String getFileName(float f, String defaultFileName, HashMap<Float, String> fNames) {
		float minDist = Float.MAX_VALUE;
		  for (Map.Entry<Float, String> entry : fNames.entrySet()) {
			  float diff = Math.abs(entry.getKey()-f);
			  if (diff<minDist){
				  minDist=diff;
				  defaultFileName=entry.getValue();
			  }
		  }
		return defaultFileName;
	}
	
	/**
	 * Draw a borderless stone slab
	 * @param dim dimension of the image
	 */
	public Image getSlabImage(Dimension2D dim) {
	    String fileName = getFileName((int)Math.rint(dim.getWidth()),(int)Math.rint(dim.getHeight()));
	    InputStream is = getClass().getResourceAsStream(fileName);
	    return new Image(is, dim.getWidth(), dim.getHeight(), false, true);
	}
	
	  /**
	   * Compute the filename based on the stretching factor
	   * @param width of the button
	   * @param height of the button
	   * @return
	   */
	  public String getFileNameExt(double width, double height, int capWidth) {
		  float f = (float)((capWidth-width)/height);
		  return getFileName(f, "StoneSlabExt.png",slabExtMap);
	  }

}
