package ch.sahits.game.openpatrician.javafx.control;

import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenu;
import ch.sahits.game.openpatrician.javafx.model.NoticeBoardMenuEntry;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;

import java.util.Optional;

/**
 * Content pane of the notice board menu.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 20, 2015
 */
@ClassCategory(EClassCategory.JAVAFX)
public class NoticeBoardScrollPaneContent extends VBox {
    private static final String DEFAULT_LABEL_STYLE = "scrollPaneContent-label";
    private static final String ACTIVE_LABEL_STYLE = "scrollPaneContent-label-active";
    private static final String DISABLED_LABEL_STYLE = "scrollPaneContent-label-disabled";

    private DoubleProperty parentWidth = new SimpleDoubleProperty(this, "parentWidth");

    public NoticeBoardScrollPaneContent() {
        getStylesheets().add(getClass().getResource(getClass().getSimpleName()+".css").toExternalForm());

    }

    public void setContent(Optional<NoticeBoardMenu> optMenu) {
        getChildren().clear();
        if (optMenu.isPresent()) {
            NoticeBoardMenu menu = optMenu.get();
            final Label title = menu.getTitle();
            title.getStyleClass().add("scrollPaneContent-title");
            getChildren().add(title);
            for (NoticeBoardMenuEntry menuItem : menu.getMenuEntries()) {
                final DecoratedText label = menuItem.getLabel();
                getChildren().add(label);
                if (menuItem.getDisabled())   {
                    applyStyle(label, DISABLED_LABEL_STYLE);
                } else if (menuItem.getSelected()) {
                    applyStyle(label, ACTIVE_LABEL_STYLE);
                } else {
                    applyStyle(label, DEFAULT_LABEL_STYLE);
                }
                menuItem.selectedProperty().addListener((observable, oldValue, newValue) -> {
                    setSelectedStyle(label, newValue);
                });
                menuItem.disabledProperty().addListener((observable, oldValue, newValue) -> {
                    setDisabledStyle(label, newValue);

                });
            }
        }

    }
    private void applyStyle(DecoratedText text, String styleClass) {
        text.applyTextStyle(true, styleClass);
    }
    private void removeStyle(DecoratedText text, String styleClass) {
        text.applyTextStyle(false, styleClass);
    }

    private void setSelectedStyle(DecoratedText label, Boolean newValue) {
        if (newValue) {
            applyStyle(label, ACTIVE_LABEL_STYLE);
            removeStyle(label, DEFAULT_LABEL_STYLE);
            removeStyle(label, DISABLED_LABEL_STYLE);
        } else {
            applyStyle(label, DEFAULT_LABEL_STYLE);
            removeStyle(label, ACTIVE_LABEL_STYLE);
            removeStyle(label, DISABLED_LABEL_STYLE);
        }
    }

    private void setDisabledStyle(DecoratedText label, Boolean newValue) {
        if (newValue) {
            label.getStyleClass().add(DISABLED_LABEL_STYLE);
            label.getStyleClass().remove(ACTIVE_LABEL_STYLE);
            label.getStyleClass().remove(DEFAULT_LABEL_STYLE);
        } else {
            label.getStyleClass().add(DEFAULT_LABEL_STYLE);
            label.getStyleClass().remove(ACTIVE_LABEL_STYLE);
            label.getStyleClass().remove(DISABLED_LABEL_STYLE);
        }
    }
}
