/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ch.sahits.game.openpatrician.javafx.layout;

import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
/**
 * Layout that will ensure that the contents is stretched to the bottom and the right.
 * If the contents is resized larger than the initial margin on the top and left, they stay
 * the same. If the contents becomes smaller the margin decreases in a linear way.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jul 14, 2013
 *
 */
public class StretchRightBottomLayout extends StackPane {
    private final int topMargin;
    private final int leftMargin;
    private Double originalWidth = null;
    private Double originalHeight = null;
    /**
     * Initialize in initial margin on the top and the left side.
     * @param topMargin
     * @param leftMargin
     */
    public StretchRightBottomLayout(int topMargin, int leftMargin) {
        this.topMargin = topMargin;
        this.leftMargin = leftMargin;
     }

    @Override
    protected void layoutChildren() {
        List<Node> managed = getManagedChildren();
        double width = getWidth();
        double height = getHeight();
        if (originalWidth == null) {
            originalWidth = width;
        }
        if (originalHeight == null) {
            originalHeight = height;
        }
        double scaleX = Math.min(computeScaleX(width), 1);
        double scaleY = Math.min(computeScaleY(height), 1);
        double top = getInsets().getTop() + topMargin*scaleY;
        double right = getInsets().getRight();
        double left = getInsets().getLeft() + leftMargin*scaleX;
        double bottom = getInsets().getBottom();
        double baselineOffset = height/2;
        for (int i = 0; i < managed.size(); i++) {
            Node child = managed.get(i);
            Pos childAlignment = StretchRightBottomLayout.getAlignment(child);
            // TODO consider translation of the child
            layoutInArea(child, left, top,
                           width - left - right, height - top - bottom,
                           baselineOffset, getMargin(child),
                           childAlignment != null? childAlignment.getHpos() : getAlignment().getHpos(),
                           childAlignment != null? childAlignment.getVpos() : getAlignment().getVpos());
        }
    }

    private double computeScaleX(double width) {
        return width / originalWidth;
    }
     private double computeScaleY(double height) {
        return height / originalHeight;
    }
}
