package ch.sahits.game.openpatrician.javafx.model;

import lombok.Getter;

/**
 * Enumeration of all dialogs.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 23, 2013
 *
 */
public enum EDialogType {
	/** Trading office balance sheet */
	TO_BALANCE(true),
	/** Trading office personal data */
	TO_PERSONAL,
	/** Trading office consumtion and production */
	TO_CONSUMPTION_PRODUCTION,
	/** Trading office ware houses */
	TO_WAREHOUSES,
	/** Trading office automatic trading */
	TO_OFFICE_TRADING,
	/** Trading office weapons */
	TO_WEAPONS,
//	/** Transfer between city and a ship */
//	CITY_TO_SHIP,
//	/** Transfer between city and the trading office */
//	CITY_TO_STORAGE,
//	/** Transfer between the trading office and a ship */
//	STORAGE_TO_SHIP,
//	/** Transfer weapons from storage to the ship */
//	WEAPON,
    /** Market booth stock and prices */
    MB_STOCK_PRICES(true),
    /** Market booth consumtion and production */
    MB_CONSUMPTION_PRODUCTION,
    /** Ware buyer in the tavern */
    TAVERN_BUYER,
    /** Sailor hiring in the tavern */
    TAVERN_SAILORS,
    /** Weapons dealer in the tavern */
    TAVERN_WEAPONS_DEALER,
    /** Informant first dialog in the tavern */
    TAVERN_INFORMANT_1,
    /** Informant second dialog in the tavern */
    TAVERN_INFORMANT_2,
    /** Captain sitting in the tavern */
    TAVERN_CAPTAIN,
    /** Pirate sitting in the tavern. */
    TAVERN_PIRATE,
    /** Traveler sitting in the tavern. */
    TAVERN_TRAVELER,
    /** Enter side room in tavern */
    TAVERN_SIDE_ROOM,
    /** Courier */
    TAVERN_COURIER,
    /** Remote trading */
    TAVERN_TRANSPORT_TRADER,
    /** Escorte */
    TAVERN_ESCORTE,
    /** Fugative */
    TAVERN_FUGATIVE,
    /** Patrol */
    TAVERN_PATROL,
    /** Burglar */
    TAVERN_BURGLAR,
    /** Concurrent */
    TAVERN_CONCURRENT,
    /** Owner of a map with a pirate nest */
    TAVERN_PIRATE_HUNTER,
    /** Warehouse tenant */
    TAVERN_WAREHOUSE_TENANT,
    /** Smuggler */
    TAVERN_SMUGGLER,
    /** Owner of a treasuremap part */
    TAVERN_TREASUREMAP_OWNER,
    /** Local trader selling wares from the city */
    TAVERN_TRADER,
    /** Build a new ship */
    SHIPYARD_CONSTRUCTION(true),
    /** Repair a ship */
    SHIPYARD_REPAIR,
    /** Rename a ship. */
    SHIPYARD_RENAME,
    /** Display the construction list */
    SHIPYARD_CONSTRUCTION_LIST,
    /** Display the repair list */
    SHIPYARD_REPAIR_LIST,
    /** Upgrade a ship. */
    SHIPYARD_UPGRADE,
    /** Hand weapon dialog */
    ARMORY_HAND_WEAPONS,
    /** Ship weapons dialog */
    ARMORY_SHIP_WEAPONS,
    /** Take a loan */
    LOANER_TAKE,
    /** Give a loan */
    LOANER_GIVE,
    /** Repay a loan */
    LOANER_REPAY,
    /** List given loans */
    LOANER_LIST,
    /** Public notice in the city hall */
    CITY_HALL_NOTICE,
    /** Outrigger notice in the city hall */
    CITY_HALL_OUTRIGGER,
    /** Town information */
    CITY_HALL_TOWN_INFO,
    /** City treasury */
    CITY_HALL_TREASURY,
    /** Hanseatic information */
    CITY_HALL_HANSEATIC_INFO,
    /** Aldermans office */
    CITY_HALL_ALDERMAN_OFFICE,
    /** Meeting room */
    CITY_HALL_MEETING_ROOM,
    /** City wall building */
    CITY_HALL_CITY_WALL,
    /** Feeding the poor. */
    CHURCH_FEED,
     /** Donate a gift to the church. */
    CHURCH_GIFT,
    /** Donate something toward the extension of the church. */
    CHURCH_EXTENSION,
    /** Pray in the church. */
    CHURCH_PRAY,
    /** History dialog of the current city */
    CITY_HISTORY,
    /** Trade between city and ship */
    PORT_CITY_TO_SHIP(true),
    /** Move wares between storage and ship */
    PORT_STORAGE_TO_SHIP,
    /** Trade wares between storage and city */
    PORT_CITY_TO_STORAGE,
    /** Weapons transfer to the ship */
    PORT_WEAPON,
    /** Create or dissolve convoy */
    SHIP_CONVOY,
    /** Join or leave a convoy */
    LEAVE_CONVOY,
    /** Join the guild */
    GUILD_JOIN,
    /** List of guild members */
    GUILD_MEMBERS,
    /** Auction of buildings and ships */
    GUILD_AUCTION,
    /** Trading spots in the mediterrean */
    GUILD_MEDITERREAN,
    /** Trading agreements in the mediterrean */
    GUILD_TRADE_AGREEMENT,
    /** Ship information. */
    SHIP_INFO;

    /** Indicates if the dialog should open when the notice board is displayed */
    @Getter
    private final boolean shouldOpenByDefault;

    EDialogType(boolean shouldOpenByDefault) {
        this.shouldOpenByDefault = shouldOpenByDefault;
    }

    EDialogType() {
        this.shouldOpenByDefault = false;
    }
}
